/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.gamemodifiers;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.boosters.BoosterItem;
import com.majruszsaccessories.gamemodifiers.contexts.OnAccessoryDropChance;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Priority;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class CustomConditions {
    public static <DataType> Condition<DataType> hasAccessory(Supplier<AccessoryItem> item, Function<DataType, LivingEntity> entity) {
        return Condition.predicate(data -> AccessoryHolder.hasAccessory((LivingEntity)entity.apply(data), (AccessoryItem)((Object)((Object)item.get()))));
    }

    public static <DataType> Condition<DataType> hasBooster(Supplier<BoosterItem> item, Function<DataType, LivingEntity> entity) {
        return Condition.predicate(data -> AccessoryHolder.hasBooster((LivingEntity)entity.apply(data), (BoosterItem)((Object)((Object)item.get()))));
    }

    public static <DataType> Condition<DataType> chance(Supplier<AccessoryItem> item, Function<DataType, LivingEntity> entity, Function<AccessoryHolder, Float> chance) {
        return Condition.predicate(data -> {
            AccessoryHolder holder = AccessoryHolder.find((LivingEntity)entity.apply(data), (AccessoryItem)((Object)((Object)item.get())));
            return holder.isValid() && Random.tryChance((double)((Float)chance.apply(holder)).floatValue());
        });
    }

    public static <DataType> Condition<DataType> dropChance(DoubleConfig chance, Function<DataType, Entity> entity) {
        return Condition.predicate(data -> OnAccessoryDropChance.dispatch((Double)chance.getOrDefault(), (Entity)entity.apply(data)).tryChance()).priority(Priority.HIGH).configurable(true).addConfig((IConfigurable)chance);
    }
}

