/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.common;

import com.majruszsaccessories.Registries;
import com.majruszsaccessories.common.ComponentBase;
import com.majruszsaccessories.gamemodifiers.contexts.OnAccessoryTooltip;
import com.mlib.client.ClientHelper;
import com.mlib.config.ConfigGroup;
import com.mlib.contexts.base.ModConfigs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.RegistryObject;

public class ItemBase<ItemType extends Item, ComponentType extends ComponentBase<ItemType>, SupplierType extends BiFunction<Supplier<ItemType>, ConfigGroup, ComponentType>> {
    protected final List<ComponentType> components = new ArrayList<ComponentType>();
    protected final Supplier<ItemType> item;
    protected final ConfigGroup group;

    public ItemBase(RegistryObject<ItemType> item, String groupId) {
        this.item = item;
        this.group = ModConfigs.init((String)groupId, (String)item.getId().toString());
    }

    public ItemBase<ItemType, ComponentType, SupplierType> name(String name) {
        this.group.name(name);
        return this;
    }

    public ItemBase<ItemType, ComponentType, SupplierType> add(SupplierType supplier) {
        this.components.add((ComponentBase)supplier.apply(this.item, (ConfigGroup)this.group));
        return this;
    }

    public List<ComponentType> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public Supplier<ItemType> getItem() {
        return this.item;
    }

    protected void addTooltip(OnAccessoryTooltip.Data data) {
        this.components.stream().map(ComponentBase::getTooltipProviders).flatMap(Collection::stream).map(provider -> ClientHelper.isShiftDown() ? provider.getDetailedTooltip(data.holder) : provider.getTooltip(data.holder)).map(component -> component.m_130940_(ChatFormatting.GRAY)).forEach(data.components::add);
    }

    protected boolean renderBoosterIcon(int xOffset, int yOffset, float blitOffset) {
        return (Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft.m_91087_().m_91291_().m_174258_(new ItemStack((ItemLike)Registries.BOOSTER_OVERLAY.get()), xOffset, yOffset, 0, 111);
            return true;
        });
    }
}

