/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.common;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.tooltip.ITooltipProvider;
import com.mlib.contexts.OnLoot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ComponentBase<ItemType extends Item> {
    protected final Supplier<ItemType> item;
    final List<ITooltipProvider> tooltipProviders = new ArrayList<ITooltipProvider>();

    public ComponentBase(Supplier<ItemType> item) {
        this.item = item;
    }

    public ComponentBase<ItemType> addTooltip(final String key, final ITooltipProvider ... providers) {
        this.tooltipProviders.add(new ITooltipProvider(){

            @Override
            public MutableComponent getTooltip(AccessoryHolder holder) {
                return new TranslatableComponent(key, Stream.of(providers).map(provider -> provider.getTooltip(holder)).toArray());
            }

            @Override
            public MutableComponent getDetailedTooltip(AccessoryHolder holder) {
                return new TranslatableComponent(key, Stream.of(providers).map(provider -> provider.getDetailedTooltip(holder)).toArray());
            }
        });
        return this;
    }

    public List<ITooltipProvider> getTooltipProviders() {
        return Collections.unmodifiableList(this.tooltipProviders);
    }

    protected void addToGeneratedLoot(OnLoot.Data data) {
        data.generatedLoot.add(this.constructItemStack());
    }

    protected ItemStack constructItemStack() {
        return new ItemStack((ItemLike)this.item.get());
    }
}

