/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.boosters.components;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.boosters.BoosterItem;
import com.majruszsaccessories.boosters.components.BoosterComponent;
import com.majruszsaccessories.tooltip.TooltipHelper;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.config.IntegerConfig;
import com.mlib.contexts.OnPlayerTick;
import com.mlib.contexts.base.Condition;
import com.mlib.math.Range;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.api.distmarker.Dist;

public class LuckBonus
extends BoosterComponent {
    static final AttributeHandler LUCK_ATTRIBUTE = new AttributeHandler("ad04ffd5-fb72-4e53-83e7-a388bd7e1e1f", "HorseshoeLuckBonus", Attributes.f_22286_, AttributeModifier.Operation.ADDITION);
    final IntegerConfig luckBonus;

    public static BoosterComponent.ISupplier create(int luck) {
        return (item, group) -> new LuckBonus((Supplier<BoosterItem>)item, (ConfigGroup)group, luck);
    }

    protected LuckBonus(Supplier<BoosterItem> item, ConfigGroup group, int luck) {
        super(item);
        this.luckBonus = new IntegerConfig(luck, new Range((Number)1, (Number)10));
        OnPlayerTick.listen(this::updateLuck).addCondition(Condition.cooldown((int)4, (Dist)Dist.DEDICATED_SERVER).configurable(false)).addConfig((IConfigurable)this.luckBonus.name("luck").comment("Extra luck bonus.")).insertTo(group);
        this.addTooltip("majruszsaccessories.boosters.luck_bonus", TooltipHelper.asItem(item), TooltipHelper.asFixedValue(this.luckBonus));
    }

    private void updateLuck(OnPlayerTick.Data data) {
        AccessoryHolder holder = AccessoryHolder.find((LivingEntity)data.player, (BoosterItem)((Object)this.item.get()));
        int luck = holder.isValid() ? holder.apply(this.luckBonus) : 0;
        LUCK_ATTRIBUTE.setValue((double)luck).apply((LivingEntity)data.player);
    }
}

