/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.boosters.components;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.boosters.BoosterItem;
import com.majruszsaccessories.boosters.components.BoosterComponent;
import com.majruszsaccessories.gamemodifiers.CustomConditions;
import com.majruszsaccessories.tooltip.TooltipHelper;
import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnPickupXp;
import com.mlib.math.Range;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;

public class ExperienceBonus
extends BoosterComponent {
    final DoubleConfig experienceExtraMultiplier;

    public static BoosterComponent.ISupplier create(double chance) {
        return (item, group) -> new ExperienceBonus((Supplier<BoosterItem>)item, (ConfigGroup)group, chance);
    }

    protected ExperienceBonus(Supplier<BoosterItem> item, ConfigGroup group, double experienceExtraMultiplier) {
        super(item);
        this.experienceExtraMultiplier = new DoubleConfig(experienceExtraMultiplier, new Range((Number)0.01, (Number)10.0));
        OnPickupXp.listen(this::increaseExperience).addCondition(CustomConditions.hasBooster(item, data -> data.player)).addConfig((IConfigurable)this.experienceExtraMultiplier.name("experience_extra_multiplier").comment("Extra experience multiplier from all sources.")).insertTo(group);
        this.addTooltip("majruszsaccessories.boosters.experience_bonus", TooltipHelper.asItem(item), TooltipHelper.asFixedPercent(this.experienceExtraMultiplier));
    }

    private void increaseExperience(OnPickupXp.Data data) {
        int experiencePoints;
        AccessoryHolder holder = AccessoryHolder.find((LivingEntity)data.player, (BoosterItem)((Object)this.item.get()));
        if (holder.isValid() && (experiencePoints = Random.round((double)((Double)this.experienceExtraMultiplier.get() * (double)data.event.getOrb().m_20801_()))) > 0) {
            data.player.m_6756_(experiencePoints);
        }
    }
}

