/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.config.IntegerConfig;
import com.mlib.math.Range;
import java.util.function.Supplier;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class TradeOffer
extends AccessoryComponent {
    final IntegerConfig price;
    final VillagerProfession profession;
    final int tier;

    public static AccessoryComponent.ISupplier create(VillagerProfession profession, int tier, int price) {
        return (item, group) -> new TradeOffer((Supplier<AccessoryItem>)item, (ConfigGroup)group, profession, tier, price);
    }

    public static AccessoryComponent.ISupplier create(VillagerProfession profession, int tier) {
        return TradeOffer.create(profession, tier, 7);
    }

    protected TradeOffer(Supplier<AccessoryItem> item, ConfigGroup group, VillagerProfession profession, int tier, int price) {
        super(item);
        this.price = new IntegerConfig(price, new Range((Number)1, (Number)32));
        this.profession = profession;
        this.tier = tier;
        group.addConfig((IConfigurable)this.price.name("trade_price").comment("Price the villager will pay for this accessory.").requiresWorldRestart(true));
    }

    public MerchantOffer toMerchantOffer() {
        return new MerchantOffer(new ItemStack((ItemLike)this.getItem(), 1), new ItemStack((ItemLike)Items.f_42616_, this.getPrice()), 2, 40, 0.05f){

            public boolean m_45355_(ItemStack itemStack1, ItemStack itemStack2) {
                return itemStack1.m_150930_((Item)TradeOffer.this.getItem()) && itemStack2.m_41619_();
            }
        };
    }

    public VillagerProfession getProfession() {
        return this.profession;
    }

    public AccessoryItem getItem() {
        return (AccessoryItem)((Object)this.item.get());
    }

    public int getTier() {
        return this.tier;
    }

    public int getPrice() {
        return (Integer)this.price.get();
    }
}

