/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.gamemodifiers.CustomConditions;
import com.majruszsaccessories.tooltip.TooltipHelper;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnBabySpawn;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Context;
import com.mlib.effects.ParticleHandler;
import com.mlib.math.Range;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;

public class SpawnTwins
extends AccessoryComponent {
    final DoubleConfig chance;

    public static AccessoryComponent.ISupplier create(double chance) {
        return (item, group) -> new SpawnTwins((Supplier<AccessoryItem>)item, (ConfigGroup)group, chance);
    }

    public static AccessoryComponent.ISupplier create() {
        return SpawnTwins.create(0.25);
    }

    protected SpawnTwins(Supplier<AccessoryItem> item, ConfigGroup group, double chance) {
        super(item);
        this.chance = new DoubleConfig(chance, Range.CHANCE);
        OnTwinsSpawn.listen(this::spawnTwins).addCondition(CustomConditions.chance(item, data -> data.player, holder -> Float.valueOf(holder.apply(this.chance)))).addConfig((IConfigurable)this.chance.name("twins_chance").comment("Chance to spawn twins when breeding animals.")).insertTo(group);
        this.addTooltip("majruszsaccessories.bonuses.spawn_twins", TooltipHelper.asPercent(this.chance));
    }

    private void spawnTwins(OnBabySpawn.Data data) {
        Animal parentA = (Animal)data.parentA;
        Animal parentB = (Animal)data.parentB;
        AgeableMob child = parentA.m_142606_(data.getServerLevel(), (AgeableMob)parentB);
        if (child == null) {
            return;
        }
        child.m_6863_(true);
        child.m_19890_(parentA.m_20185_(), parentA.m_20186_(), parentA.m_20189_(), 0.0f, 0.0f);
        data.getLevel().m_7967_((Entity)child);
        ParticleHandler.AWARD.spawn(data.getServerLevel(), child.m_20182_().m_82520_(0.0, 0.5, 0.0), 8, ParticleHandler.offset((float)2.0f));
    }

    public static class OnTwinsSpawn {
        public static Context<OnBabySpawn.Data> listen(Consumer<OnBabySpawn.Data> consumer) {
            return OnBabySpawn.listen(consumer).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> data.player != null)).addCondition(Condition.predicate(data -> data.parentA instanceof Animal)).addCondition(Condition.predicate(data -> data.parentB instanceof Animal));
        }
    }
}

