/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.gamemodifiers.CustomConditions;
import com.majruszsaccessories.tooltip.ITooltipProvider;
import com.majruszsaccessories.tooltip.TooltipHelper;
import com.mlib.Random;
import com.mlib.blocks.BlockHelper;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnLoot;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Context;
import com.mlib.effects.ParticleHandler;
import com.mlib.levels.LevelHelper;
import com.mlib.math.Range;
import com.mlib.text.TextHelper;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.phys.Vec3;

public class MoreChestLoot
extends AccessoryComponent {
    static final int BLOCKS_DISTANCE = 6000;
    final DoubleConfig sizeMultiplier;

    public static AccessoryComponent.ISupplier create(double sizeMultiplier) {
        return (item, group) -> new MoreChestLoot((Supplier<AccessoryItem>)item, (ConfigGroup)group, sizeMultiplier);
    }

    public static AccessoryComponent.ISupplier create() {
        return MoreChestLoot.create(1.2);
    }

    protected MoreChestLoot(Supplier<AccessoryItem> item, ConfigGroup group, double sizeMultiplier) {
        super(item);
        this.sizeMultiplier = new DoubleConfig(sizeMultiplier, new Range((Number)0.0, (Number)10.0));
        this.sizeMultiplier.name("chest_size_bonus").comment("Extra multiplier for number of items acquired from chests.");
        OnChestOpened.listen(this::increaseLoot).addCondition(CustomConditions.hasAccessory(this.item, data -> (LivingEntity)data.entity)).addConfig((IConfigurable)this.sizeMultiplier).insertTo(group);
        this.addTooltip("majruszsaccessories.bonuses.more_chest_loot", this.getPercentInfo(), this.getBlockInfo(), TooltipHelper.asPercent(this.sizeMultiplier));
    }

    private void increaseLoot(OnLoot.Data data) {
        boolean hasIncreasedLoot = false;
        float sizeMultiplier = this.getFinalSizeMultiplier((ServerPlayer)data.entity);
        for (ItemStack itemStack : data.generatedLoot) {
            int count = Math.min(Random.round((double)(sizeMultiplier * (float)itemStack.m_41613_())), itemStack.m_41741_());
            hasIncreasedLoot = hasIncreasedLoot || count > itemStack.m_41613_();
            itemStack.m_41764_(count);
        }
        if (hasIncreasedLoot) {
            ParticleHandler.AWARD.spawn(data.getServerLevel(), data.origin, 16, ParticleHandler.offset((float)0.5f));
        }
    }

    private float getFinalSizeMultiplier(ServerPlayer player) {
        AccessoryHolder holder = AccessoryHolder.find((LivingEntity)player, (AccessoryItem)((Object)this.item.get()));
        Pair spawnData = LevelHelper.getSpawnData((ServerPlayer)player);
        float distanceMultiplier = (float)Mth.m_14008_((double)(((Vec3)spawnData.getFirst()).m_82554_(player.m_20182_()) / 6000.0), (double)0.0, (double)1.0);
        return 1.0f + holder.apply(this.sizeMultiplier) * distanceMultiplier;
    }

    private ITooltipProvider getPercentInfo() {
        return new ITooltipProvider(){

            @Override
            public MutableComponent getTooltip(AccessoryHolder holder) {
                float bonus = holder.getBonus();
                return new TranslatableComponent(TextHelper.percent((float)(0.01f + holder.getBonus() / 100.0f))).m_130940_(bonus != 0.0f ? holder.getBonusFormatting() : TooltipHelper.DEFAULT_FORMAT);
            }

            @Override
            public MutableComponent getDetailedTooltip(AccessoryHolder holder) {
                float bonus = holder.getBonus();
                return TooltipHelper.asFormula(TextHelper.percent((float)0.01f), new TextComponent(TextHelper.signedPercent((float)(holder.getBonus() / 100.0f))).m_130940_(bonus != 0.0f ? holder.getBonusFormatting() : TooltipHelper.DEFAULT_FORMAT));
            }
        };
    }

    private ITooltipProvider getBlockInfo() {
        return holder -> new TranslatableComponent("" + Math.round(6000.0 / ((Double)this.sizeMultiplier.get() * 100.0)));
    }

    public static class OnChestOpened {
        public static Context<OnLoot.Data> listen(Consumer<OnLoot.Data> consumer) {
            return OnLoot.listen(consumer).addCondition(Condition.isServer()).addCondition(OnLoot.hasOrigin()).addCondition(Condition.predicate(data -> BlockHelper.getBlockEntity((Level)data.getLevel(), (Vec3)data.origin) instanceof RandomizableContainerBlockEntity || data.context.getQueriedLootTableId().toString().contains("chest"))).addCondition(Condition.predicate(data -> data.entity instanceof ServerPlayer));
        }
    }
}

