/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.tooltip.TooltipHelper;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnFishingTimeSet;
import com.mlib.math.Range;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;

public class FishingLureBonus
extends AccessoryComponent {
    final DoubleConfig timeMultiplier;

    public static AccessoryComponent.ISupplier create(double bonus) {
        return (item, group) -> new FishingLureBonus((Supplier<AccessoryItem>)item, (ConfigGroup)group, bonus);
    }

    public static AccessoryComponent.ISupplier create() {
        return FishingLureBonus.create(0.4);
    }

    protected FishingLureBonus(Supplier<AccessoryItem> item, ConfigGroup group, double bonus) {
        super(item);
        this.timeMultiplier = new DoubleConfig(bonus, new Range((Number)0.01, (Number)0.99));
        OnFishingTimeSet.listen(this::decreaseFishingTime).addCondition(OnFishingTimeSet.hasPlayer()).addConfig((IConfigurable)this.timeMultiplier.name("time_multiplier").comment("Time reduction multiplier when fishing.")).insertTo(group);
        this.addTooltip("majruszsaccessories.bonuses.fishing_lure", TooltipHelper.asPercent(this.timeMultiplier));
    }

    private void decreaseFishingTime(OnFishingTimeSet.Data data) {
        AccessoryHolder holder = AccessoryHolder.find((LivingEntity)data.player, (AccessoryItem)((Object)this.item.get()));
        float multiplier = holder.isValid() ? holder.apply(this.timeMultiplier) : 0.0f;
        data.ticks = Math.round((float)data.ticks * (1.0f - multiplier));
    }
}

