/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.tooltip.TooltipHelper;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.config.IntegerConfig;
import com.mlib.contexts.OnPlayerTick;
import com.mlib.contexts.base.Condition;
import com.mlib.math.Range;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;

public class FishingLuckBonus
extends AccessoryComponent {
    static final AttributeHandler LUCK_ATTRIBUTE = new AttributeHandler("4010270c-9d57-4273-8a41-00985f1e4781", "FishingLuckBonus", Attributes.f_22286_, AttributeModifier.Operation.ADDITION);
    final IntegerConfig luck;

    public static AccessoryComponent.ISupplier create(int luck) {
        return (item, group) -> new FishingLuckBonus((Supplier<AccessoryItem>)item, (ConfigGroup)group, luck);
    }

    public static AccessoryComponent.ISupplier create() {
        return FishingLuckBonus.create(3);
    }

    protected FishingLuckBonus(Supplier<AccessoryItem> item, ConfigGroup group, int luck) {
        super(item);
        this.luck = new IntegerConfig(luck, new Range((Number)1, (Number)10));
        OnPlayerTick.listen(this::updateLuck).addCondition(Condition.cooldown((int)4, (Dist)Dist.DEDICATED_SERVER).configurable(false)).addConfig((IConfigurable)this.luck.name("fishing_luck").comment("Luck bonus when fishing.")).insertTo(group);
        this.addTooltip("majruszsaccessories.bonuses.fishing_luck", TooltipHelper.asValue(this.luck));
    }

    private void updateLuck(OnPlayerTick.Data data) {
        LUCK_ATTRIBUTE.setValue((double)this.getLuck(data.player)).apply((LivingEntity)data.player);
    }

    private int getLuck(Player player) {
        if (player.f_36083_ == null) {
            return 0;
        }
        AccessoryHolder holder = AccessoryHolder.find((LivingEntity)player, (AccessoryItem)((Object)this.item.get()));
        return holder.isValid() ? holder.apply(this.luck) : 0;
    }
}

