/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszsaccessories.Registries;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.gamemodifiers.CustomConditions;
import com.majruszsaccessories.tooltip.TooltipHelper;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnLoot;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Context;
import com.mlib.contexts.base.Priority;
import com.mlib.effects.ParticleHandler;
import com.mlib.levels.LevelHelper;
import com.mlib.loot.LootHelper;
import com.mlib.math.Range;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;

public class ExtraStoneLoot
extends AccessoryComponent {
    public static final ResourceLocation LOOT_OVERWORLD = Registries.getLocation("gameplay/lucky_rock_overworld");
    public static final ResourceLocation LOOT_THE_NETHER = Registries.getLocation("gameplay/lucky_rock_nether");
    public static final ResourceLocation LOOT_THE_END = Registries.getLocation("gameplay/lucky_rock_end");
    final DoubleConfig chance;

    public static AccessoryComponent.ISupplier create(double chance) {
        return (item, group) -> new ExtraStoneLoot((Supplier<AccessoryItem>)item, (ConfigGroup)group, chance);
    }

    public static AccessoryComponent.ISupplier create() {
        return ExtraStoneLoot.create(0.03);
    }

    protected ExtraStoneLoot(Supplier<AccessoryItem> item, ConfigGroup group, double chance) {
        super(item);
        this.chance = new DoubleConfig(chance, Range.CHANCE);
        OnStoneMined.listen(this::addExtraLoot).addCondition(CustomConditions.chance(item, data -> (LivingEntity)data.entity, holder -> Float.valueOf(holder.apply(this.chance)))).addConfig((IConfigurable)this.chance.name("extra_loot_chance").comment("Chance to drop extra items when mining stone.")).insertTo(group);
        this.addTooltip("majruszsaccessories.bonuses.extra_stone_loot", TooltipHelper.asPercent(this.chance));
    }

    private void addExtraLoot(OnLoot.Data data) {
        data.generatedLoot.addAll(ExtraStoneLoot.generateLoot((LivingEntity)data.entity));
        ParticleHandler.AWARD.spawn(data.getServerLevel(), data.origin, 5);
    }

    private static List<ItemStack> generateLoot(LivingEntity entity) {
        return LootHelper.getLootTable((ResourceLocation)ExtraStoneLoot.getLootTableLocation(entity)).m_79129_(LootHelper.toGiftContext((Entity)entity));
    }

    private static ResourceLocation getLootTableLocation(LivingEntity entity) {
        if (LevelHelper.isEntityIn((Entity)entity, (ResourceKey)Level.f_46429_)) {
            return LOOT_THE_NETHER;
        }
        if (LevelHelper.isEntityIn((Entity)entity, (ResourceKey)Level.f_46430_)) {
            return LOOT_THE_END;
        }
        return LOOT_OVERWORLD;
    }

    public static class OnStoneMined {
        public static Context<OnLoot.Data> listen(Consumer<OnLoot.Data> consumer) {
            return OnLoot.listen(consumer).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> data.blockState != null && data.blockState.m_60767_() == Material.f_76278_)).addCondition(Condition.predicate(data -> data.entity instanceof LivingEntity).priority(Priority.HIGH)).addCondition(OnLoot.hasOrigin());
        }
    }
}

