/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.gamemodifiers.CustomConditions;
import com.majruszsaccessories.tooltip.TooltipHelper;
import com.mlib.Utility;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.config.IntegerConfig;
import com.mlib.contexts.OnPotionBrewed;
import com.mlib.contexts.base.Condition;
import com.mlib.math.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;

public class EnhancedPotions
extends AccessoryComponent {
    final DoubleConfig duration;
    final IntegerConfig amplifier;

    public static AccessoryComponent.ISupplier create(double durationPenalty, int extraLevel) {
        return (item, group) -> new EnhancedPotions((Supplier<AccessoryItem>)item, (ConfigGroup)group, durationPenalty, extraLevel);
    }

    public static AccessoryComponent.ISupplier create() {
        return EnhancedPotions.create(0.6, 1);
    }

    protected EnhancedPotions(Supplier<AccessoryItem> item, ConfigGroup group, double durationPenalty, int extraLevel) {
        super(item);
        this.duration = new DoubleConfig(durationPenalty, new Range((Number)0.0, (Number)0.99));
        this.amplifier = new IntegerConfig(extraLevel, new Range((Number)1, (Number)10));
        OnPotionBrewed.listen(this::enhancePotion).addCondition(Condition.predicate(data -> PotionUtils.m_43547_((ItemStack)data.itemStack).size() > 0)).addCondition(Condition.predicate(data -> !data.itemStack.m_41784_().m_128441_("CustomPotionEffects"))).addCondition(CustomConditions.hasAccessory(item, data -> data.player)).addConfig((IConfigurable)this.duration.name("potion_duration_penalty").comment("Duration penalty for created enhanced potions.")).addConfig((IConfigurable)this.amplifier.name("potion_extra_amplifier").comment("Extra potion level for created enhanced potions.")).insertTo(group);
        this.addTooltip("majruszsaccessories.bonuses.potion_amplifier", TooltipHelper.asValue(this.amplifier));
        this.addTooltip("majruszsaccessories.bonuses.potion_duration", TooltipHelper.asPercent(this.duration, -1.0));
    }

    private void enhancePotion(OnPotionBrewed.Data data) {
        AccessoryHolder holder = AccessoryHolder.find((LivingEntity)data.player, (AccessoryItem)((Object)this.item.get()));
        List effects = PotionUtils.m_43547_((ItemStack)data.itemStack);
        List<MobEffectInstance> enhancedEffects = this.getEnhancedEffects(holder, effects);
        PotionUtils.m_43552_((ItemStack)data.itemStack, enhancedEffects);
        this.updatePotionName(data.itemStack);
    }

    private void updatePotionName(ItemStack itemStack) {
        itemStack.m_41784_().m_128359_("Potion", Potions.f_43602_.m_43492_(""));
        itemStack.m_41698_("display").m_128359_("Name", "{\"translate\":\"majruszsaccessories.bonuses.potion_name\",\"italic\":false}");
    }

    private List<MobEffectInstance> getEnhancedEffects(AccessoryHolder holder, List<MobEffectInstance> effects) {
        ArrayList<MobEffectInstance> enhancedEffects = new ArrayList<MobEffectInstance>();
        float durationMultiplier = 1.0f - holder.apply(this.duration, -1.0);
        int extraAmplifier = holder.apply(this.amplifier);
        for (MobEffectInstance effect : effects) {
            int duration = Math.max(Utility.secondsToTicks((double)2.0), (int)((float)effect.m_19557_() * durationMultiplier));
            int amplifier = effect.m_19564_() + extraAmplifier;
            enhancedEffects.add(new MobEffectInstance(effect.m_19544_(), duration, amplifier));
        }
        return enhancedEffects;
    }
}

