/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszsaccessories.AccessoryHolder;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.gamemodifiers.CustomConditions;
import com.majruszsaccessories.tooltip.TooltipHelper;
import com.mlib.attributes.AttributeHandler;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnAnimalTame;
import com.mlib.effects.ParticleHandler;
import com.mlib.math.Range;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Horse;

public class EnhanceTamedAnimal
extends AccessoryComponent {
    static final AttributeHandler HEALTH = new AttributeHandler("ec10e191-9ab4-40e5-a757-91e57104d3ab", "CoTHealthMultiplier", Attributes.f_22276_, AttributeModifier.Operation.MULTIPLY_BASE);
    static final AttributeHandler DAMAGE = new AttributeHandler("f1d3671c-9474-4ffd-a440-902d69bd3bd9", "CoTDamageMultiplier", Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_BASE);
    static final AttributeHandler SPEED = new AttributeHandler("ed1c5feb-1017-4dc2-8a8b-7a64388f0dea", "CoTSpeedMultiplier", Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_BASE);
    static final AttributeHandler JUMP_HEIGHT = new AttributeHandler("8c065a4c-98de-4ce4-adda-41ae7a20abfb", "CoTJumpHeightMultiplier", Attributes.f_22288_, AttributeModifier.Operation.MULTIPLY_BASE);
    final DoubleConfig bonus;

    public static AccessoryComponent.ISupplier create(double bonus) {
        return (item, group) -> new EnhanceTamedAnimal((Supplier<AccessoryItem>)item, (ConfigGroup)group, bonus);
    }

    public static AccessoryComponent.ISupplier create() {
        return EnhanceTamedAnimal.create(0.2);
    }

    protected EnhanceTamedAnimal(Supplier<AccessoryItem> item, ConfigGroup group, double bonus) {
        super(item);
        this.bonus = new DoubleConfig(bonus, new Range((Number)0.0, (Number)10.0));
        OnAnimalTame.listen(this::enhanceAnimal).addCondition(CustomConditions.hasAccessory(item, data -> data.tamer)).addConfig((IConfigurable)this.bonus.name("animal_bonus").comment("Bonus health, damage, movement speed and jump height for tamed animals.")).insertTo(group);
        this.addTooltip("majruszsaccessories.bonuses.animal_health", TooltipHelper.asPercent(this.bonus)).addTooltip("majruszsaccessories.bonuses.animal_damage", TooltipHelper.asPercent(this.bonus)).addTooltip("majruszsaccessories.bonuses.animal_speed", TooltipHelper.asPercent(this.bonus)).addTooltip("majruszsaccessories.bonuses.animal_jump_height", TooltipHelper.asPercent(this.bonus));
    }

    private void enhanceAnimal(OnAnimalTame.Data data) {
        Animal animal;
        AccessoryHolder holder = AccessoryHolder.find((LivingEntity)data.tamer, (AccessoryItem)((Object)this.item.get()));
        float bonus = holder.apply(this.bonus);
        HEALTH.setValue((double)bonus).apply((LivingEntity)data.animal);
        if (AttributeHandler.hasAttribute((LivingEntity)data.animal, (Attribute)Attributes.f_22281_)) {
            DAMAGE.setValue((double)bonus).apply((LivingEntity)data.animal);
        }
        if ((animal = data.animal) instanceof Horse) {
            Horse horse = (Horse)animal;
            JUMP_HEIGHT.setValue((double)bonus).apply((LivingEntity)horse);
            SPEED.setValue((double)bonus).apply((LivingEntity)horse);
        }
        data.animal.m_21153_(data.animal.m_21233_());
        animal = data.getLevel();
        if (animal instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)animal;
            ParticleHandler.AWARD.spawn(level, data.animal.m_20182_().m_82520_(0.0, 0.5, 0.0), 8, ParticleHandler.offset((float)2.0f));
        }
    }
}

