/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszsaccessories.Registries;
import com.majruszsaccessories.accessories.AccessoryBase;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.accessories.components.ReduceDamageDealt;
import com.majruszsaccessories.accessories.components.ReduceDamageReceived;
import com.majruszsaccessories.accessories.components.TradeOffer;
import com.majruszsaccessories.gamemodifiers.CustomConditions;
import com.mlib.Utility;
import com.mlib.blocks.BlockHelper;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.StringListConfig;
import com.mlib.contexts.OnLoot;
import com.mlib.contexts.OnPlayerInteract;
import com.mlib.contexts.base.Condition;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;

@AutoInstance
public class WhiteFlag
extends AccessoryBase {
    public WhiteFlag() {
        super(Registries.WHITE_FLAG);
        this.name("WhiteFlag").add(ReduceDamageReceived.create()).add(ReduceDamageDealt.create()).add(TradeOffer.create(VillagerProfession.f_35594_, 5)).add(SwingBehavior.create()).add(AddToVillageChests.create());
    }

    static class SwingBehavior
    extends AccessoryComponent {
        public static AccessoryComponent.ISupplier create() {
            return SwingBehavior::new;
        }

        protected SwingBehavior(Supplier<AccessoryItem> item, ConfigGroup group) {
            super(item);
            OnPlayerInteract.listen(this::swing).addCondition(Condition.predicate(data -> data.itemStack.m_41720_().equals(item.get()))).addCondition(Condition.predicate(data -> !data.player.m_36335_().m_41519_(data.itemStack.m_41720_()))).insertTo(group);
        }

        private void swing(OnPlayerInteract.Data data) {
            data.player.m_6674_(data.hand);
            data.player.m_36335_().m_41524_(data.itemStack.m_41720_(), Utility.secondsToTicks((double)0.5));
        }
    }

    static class AddToVillageChests
    extends AccessoryComponent {
        public static AccessoryComponent.ISupplier create() {
            return AddToVillageChests::new;
        }

        protected AddToVillageChests(Supplier<AccessoryItem> item, ConfigGroup group) {
            super(item);
            DoubleConfig chance = new DoubleConfig(0.15, Range.CHANCE);
            chance.name("spawn_chance").comment("Chance for White Flag to spawn in any village chest.");
            StringListConfig villageIds = new StringListConfig((String[])Stream.of(BuiltInLootTables.f_78743_, BuiltInLootTables.f_78744_, BuiltInLootTables.f_78745_, BuiltInLootTables.f_78745_, BuiltInLootTables.f_78746_, BuiltInLootTables.f_78747_, BuiltInLootTables.f_78748_, BuiltInLootTables.f_78749_, BuiltInLootTables.f_78750_, BuiltInLootTables.f_78751_, BuiltInLootTables.f_78752_, BuiltInLootTables.f_78753_, BuiltInLootTables.f_78754_, BuiltInLootTables.f_78755_, BuiltInLootTables.f_78756_, BuiltInLootTables.f_78757_, BuiltInLootTables.f_78758_).map(ResourceLocation::toString).toArray(String[]::new));
            villageIds.name("loot_table_ids").comment("Determines which chests should contain White Flag.");
            OnLoot.listen(x$0 -> this.addToGeneratedLoot((OnLoot.Data)x$0)).addCondition(Condition.isServer()).addCondition(CustomConditions.dropChance(chance, data -> data.entity)).addCondition(OnLoot.is((StringListConfig)villageIds)).addCondition(OnLoot.hasOrigin()).addCondition(Condition.predicate(data -> BlockHelper.getBlockEntity((Level)data.getLevel(), (Vec3)data.origin) instanceof RandomizableContainerBlockEntity)).addCondition(Condition.predicate(data -> data.entity instanceof ServerPlayer)).insertTo(group);
        }
    }
}

