/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszsaccessories.Registries;
import com.majruszsaccessories.accessories.AccessoryBase;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.accessories.components.DoubleCrops;
import com.majruszsaccessories.accessories.components.TradeOffer;
import com.majruszsaccessories.gamemodifiers.contexts.OnAccessoryDropChance;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnLoot;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Priority;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Blocks;

@AutoInstance
public class TamedPotatoBeetle
extends AccessoryBase {
    public TamedPotatoBeetle() {
        super(Registries.TAMED_POTATO_BEETLE);
        this.name("TamedPotatoBeetle").add(DoubleCrops.create()).add(TradeOffer.create(VillagerProfession.f_35590_, 5)).add(DropChance.create());
    }

    static class DropChance
    extends AccessoryComponent {
        public static AccessoryComponent.ISupplier create() {
            return DropChance::new;
        }

        protected DropChance(Supplier<AccessoryItem> item, ConfigGroup group) {
            super(item);
            DoubleCrops.OnHarvest.listen(x$0 -> this.addToGeneratedLoot((OnLoot.Data)x$0)).addCondition(DropChance.chance()).insertTo(group);
        }

        private static Condition<OnLoot.Data> chance() {
            DoubleConfig chance = new DoubleConfig(0.002, Range.CHANCE);
            DoubleConfig chanceMultiplier = new DoubleConfig(2.5, new Range((Number)1.0, (Number)10.0));
            Predicate<OnLoot.Data> predicate = data -> {
                double finalChance = (Double)chance.getOrDefault();
                if (data.blockState != null && data.blockState.m_60734_().equals(Blocks.f_50250_)) {
                    finalChance *= ((Double)chanceMultiplier.getOrDefault()).doubleValue();
                }
                return OnAccessoryDropChance.dispatch(finalChance, data.entity).tryChance();
            };
            return Condition.predicate(predicate).priority(Priority.HIGH).configurable(true).addConfig((IConfigurable)chance.name("drop_chance").comment("Chance for Tamed Potato Beetle to drop when harvesting.")).addConfig((IConfigurable)chanceMultiplier.name("potato_multiplier").comment("Chance multiplier when harvesting potatoes."));
        }
    }
}

