/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszsaccessories.Registries;
import com.majruszsaccessories.accessories.AccessoryBase;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.accessories.components.EnhancedPotions;
import com.majruszsaccessories.accessories.components.TradeOffer;
import com.majruszsaccessories.gamemodifiers.CustomConditions;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.contexts.OnLoot;
import com.mlib.contexts.base.Condition;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Supplier;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.VillagerProfession;

@AutoInstance
public class SecretIngredient
extends AccessoryBase {
    public SecretIngredient() {
        super(Registries.SECRET_INGREDIENT);
        this.name("SecretIngredient").add(EnhancedPotions.create()).add(TradeOffer.create(VillagerProfession.f_35589_, 5)).add(DropChance.create());
    }

    static class DropChance
    extends AccessoryComponent {
        public static AccessoryComponent.ISupplier create() {
            return DropChance::new;
        }

        protected DropChance(Supplier<AccessoryItem> item, ConfigGroup group) {
            super(item);
            DoubleConfig chance = new DoubleConfig(0.025, Range.CHANCE);
            chance.name("drop_chance").comment("Chance for Secret Ingredient to drop from Witch.");
            OnLoot.listen(x$0 -> this.addToGeneratedLoot((OnLoot.Data)x$0)).addCondition(Condition.isServer()).addCondition(CustomConditions.dropChance(chance, data -> data.killer)).addCondition(OnLoot.hasLastDamagePlayer()).addCondition(Condition.predicate(data -> data.entity instanceof Witch)).insertTo(group);
        }
    }
}

