/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszsaccessories.Registries;
import com.majruszsaccessories.accessories.AccessoryBase;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.accessories.components.ExtraStoneLoot;
import com.majruszsaccessories.accessories.components.TradeOffer;
import com.majruszsaccessories.gamemodifiers.CustomConditions;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.contexts.OnLoot;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Supplier;
import net.minecraft.world.entity.npc.VillagerProfession;

@AutoInstance
public class LuckyRock
extends AccessoryBase {
    public LuckyRock() {
        super(Registries.LUCKY_ROCK);
        this.name("LuckyRock").add(ExtraStoneLoot.create()).add(TradeOffer.create(VillagerProfession.f_35595_, 5)).add(DropChance.create());
    }

    static class DropChance
    extends AccessoryComponent {
        public static AccessoryComponent.ISupplier create() {
            return DropChance::new;
        }

        protected DropChance(Supplier<AccessoryItem> item, ConfigGroup group) {
            super(item);
            DoubleConfig chance = new DoubleConfig(5.0E-4, Range.CHANCE);
            chance.name("drop_chance").comment("Chance for Lucky Rock to drop when mining stone.");
            ExtraStoneLoot.OnStoneMined.listen(x$0 -> this.addToGeneratedLoot((OnLoot.Data)x$0)).addCondition(CustomConditions.dropChance(chance, data -> data.entity)).insertTo(group);
        }
    }
}

