/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszsaccessories.Registries;
import com.majruszsaccessories.accessories.AccessoryBase;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.accessories.components.SpawnTwins;
import com.majruszsaccessories.accessories.components.TradeOffer;
import com.majruszsaccessories.gamemodifiers.CustomConditions;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.contexts.OnBabySpawn;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Supplier;
import net.minecraft.world.entity.npc.VillagerProfession;

@AutoInstance
public class IdolOfFertility
extends AccessoryBase {
    public IdolOfFertility() {
        super(Registries.IDOL_OF_FERTILITY);
        this.name("IdolOfFertility").add(SpawnTwins.create()).add(TradeOffer.create(VillagerProfession.f_35587_, 5)).add(DropChance.create());
    }

    static class DropChance
    extends AccessoryComponent {
        public static AccessoryComponent.ISupplier create() {
            return DropChance::new;
        }

        protected DropChance(Supplier<AccessoryItem> item, ConfigGroup group) {
            super(item);
            DoubleConfig chance = new DoubleConfig(0.01, Range.CHANCE);
            chance.name("drop_chance").comment("Chance for Idol of Fertility to drop when breeding animals.");
            SpawnTwins.OnTwinsSpawn.listen(this::spawnTotem).addCondition(CustomConditions.dropChance(chance, data -> data.player)).insertTo(group);
        }

        private void spawnTotem(OnBabySpawn.Data data) {
            this.spawnFlyingItem(data.getLevel(), data.parentA.m_20182_(), data.parentB.m_20182_());
        }
    }
}

