/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszsaccessories.Registries;
import com.majruszsaccessories.accessories.AccessoryBase;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.accessories.components.AccessoryComponent;
import com.majruszsaccessories.accessories.components.MoreChestLoot;
import com.majruszsaccessories.accessories.components.TradeOffer;
import com.majruszsaccessories.gamemodifiers.CustomConditions;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.contexts.OnLoot;
import com.mlib.math.Range;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Supplier;
import net.minecraft.world.entity.npc.VillagerProfession;

@AutoInstance
public class AdventurersGuide
extends AccessoryBase {
    public AdventurersGuide() {
        super(Registries.ADVENTURERS_GUIDE);
        this.name("AdventurersGuide").add(MoreChestLoot.create()).add(DropChance.create()).add(TradeOffer.create(VillagerProfession.f_35588_, 5));
    }

    static class DropChance
    extends AccessoryComponent {
        public static AccessoryComponent.ISupplier create() {
            return DropChance::new;
        }

        protected DropChance(Supplier<AccessoryItem> item, ConfigGroup group) {
            super(item);
            DoubleConfig chance = new DoubleConfig(0.025, Range.CHANCE);
            chance.name("spawn_chance").comment("Chance for Adventurer's Guide to spawn in any chest.");
            MoreChestLoot.OnChestOpened.listen(x$0 -> this.addToGeneratedLoot((OnLoot.Data)x$0)).addCondition(CustomConditions.dropChance(chance, data -> data.entity)).insertTo(group);
        }
    }
}

