/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories;

import com.majruszsaccessories.Integration;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.boosters.BoosterItem;
import com.majruszsaccessories.items.BoosterOverlay;
import com.majruszsaccessories.recipes.AccessoryRecipe;
import com.majruszsaccessories.recipes.BoostAccessoriesRecipe;
import com.majruszsaccessories.recipes.CombineAccessoriesRecipe;
import com.mlib.config.ConfigHandler;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.items.CreativeModeTabHelper;
import com.mlib.modhelper.ModHelper;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.SlotTypeMessage;

public class Registries {
    public static final ModHelper HELPER = ModHelper.create((String)"majruszsaccessories");
    public static final ConfigHandler SERVER_CONFIG = HELPER.createConfig(ModConfig.Type.SERVER);
    static final DeferredRegister<Item> ITEMS;
    static final DeferredRegister<RecipeSerializer<?>> RECIPES;
    public static final RegistryObject<AccessoryItem> ADVENTURERS_GUIDE;
    public static final RegistryObject<AccessoryItem> ANGLERS_TROPHY;
    public static final RegistryObject<AccessoryItem> CERTIFICATE_OF_TAMING;
    public static final RegistryObject<BoosterItem> DICE;
    public static final RegistryObject<BoosterItem> GOLDEN_DICE;
    public static final RegistryObject<BoosterItem> GOLDEN_HORSESHOE;
    public static final RegistryObject<BoosterItem> HORSESHOE;
    public static final RegistryObject<AccessoryItem> IDOL_OF_FERTILITY;
    public static final RegistryObject<AccessoryItem> LUCKY_ROCK;
    public static final RegistryObject<BoosterItem> OWL_FEATHER;
    public static final RegistryObject<AccessoryItem> OVERWORLD_RUNE;
    public static final RegistryObject<AccessoryItem> SECRET_INGREDIENT;
    public static final RegistryObject<AccessoryItem> TAMED_POTATO_BEETLE;
    public static final RegistryObject<AccessoryItem> WHITE_FLAG;
    public static final RegistryObject<RecipeSerializer<?>> ACCESSORY_RECIPE;
    public static final RegistryObject<RecipeSerializer<?>> COMBINE_ACCESSORIES_RECIPE;
    public static final RegistryObject<RecipeSerializer<?>> BOOST_ACCESSORIES_RECIPE;
    public static final ResourceLocation ACCESSORY_SLOT_TEXTURE;
    public static final CreativeModeTab ITEM_GROUP;
    public static final RegistryObject<Item> BOOSTER_OVERLAY;

    public static void initialize() {
        FMLJavaModLoadingContext loadingContext = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = loadingContext.getModEventBus();
        modEventBus.addListener(Registries::onEnqueueIMC);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(Registries::onTextureStitch));
        HELPER.register();
    }

    public static ResourceLocation getLocation(String register) {
        return HELPER.getLocation(register);
    }

    public static String getLocationString(String register) {
        return HELPER.getLocationString(register);
    }

    private static void onEnqueueIMC(InterModEnqueueEvent event) {
        if (!Integration.isCuriosInstalled()) {
            return;
        }
        InterModComms.sendTo((String)"majruszsaccessories", (String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("pocket").priority(220).icon(ACCESSORY_SLOT_TEXTURE).build());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onTextureStitch(TextureStitchEvent.Pre event) {
        TextureAtlas map = event.getAtlas();
        if (InventoryMenu.f_39692_.equals((Object)map.m_118330_())) {
            event.addSprite(ACCESSORY_SLOT_TEXTURE);
        }
    }

    static {
        ModConfigs.init((ConfigHandler)SERVER_CONFIG, (String)Groups.DEFAULT);
        ModConfigs.init((ConfigHandler)SERVER_CONFIG, (String)Groups.ACCESSORIES).name("Accessories");
        ModConfigs.init((ConfigHandler)SERVER_CONFIG, (String)Groups.BOOSTERS).name("Boosters");
        ITEMS = HELPER.create(ForgeRegistries.Keys.ITEMS);
        RECIPES = HELPER.create(ForgeRegistries.Keys.RECIPE_SERIALIZERS);
        ADVENTURERS_GUIDE = ITEMS.register("adventurers_guide", AccessoryItem::new);
        ANGLERS_TROPHY = ITEMS.register("anglers_trophy", AccessoryItem::new);
        CERTIFICATE_OF_TAMING = ITEMS.register("certificate_of_taming", AccessoryItem::new);
        DICE = ITEMS.register("dice", BoosterItem.basic());
        GOLDEN_DICE = ITEMS.register("golden_dice", BoosterItem.rare());
        GOLDEN_HORSESHOE = ITEMS.register("golden_horseshoe", BoosterItem.rare());
        HORSESHOE = ITEMS.register("horseshoe", BoosterItem.basic());
        IDOL_OF_FERTILITY = ITEMS.register("idol_of_fertility", AccessoryItem::new);
        LUCKY_ROCK = ITEMS.register("lucky_rock", AccessoryItem::new);
        OWL_FEATHER = ITEMS.register("owl_feather", BoosterItem.basic());
        OVERWORLD_RUNE = ITEMS.register("overworld_rune", AccessoryItem::new);
        SECRET_INGREDIENT = ITEMS.register("secret_ingredient", AccessoryItem::new);
        TAMED_POTATO_BEETLE = ITEMS.register("tamed_potato_beetle", AccessoryItem::new);
        WHITE_FLAG = ITEMS.register("white_flag", AccessoryItem::new);
        ACCESSORY_RECIPE = RECIPES.register("crafting_accessory", AccessoryRecipe.create());
        COMBINE_ACCESSORIES_RECIPE = RECIPES.register("crafting_combine_accessories", CombineAccessoriesRecipe.create());
        BOOST_ACCESSORIES_RECIPE = RECIPES.register("crafting_boost_accessories", BoostAccessoriesRecipe.create());
        ACCESSORY_SLOT_TEXTURE = Registries.getLocation("item/empty_accessory_slot");
        ITEM_GROUP = CreativeModeTabHelper.newTab((String)"majruszsaccessories.primary", LUCKY_ROCK);
        BOOSTER_OVERLAY = ITEMS.register("booster_icon", BoosterOverlay::new);
    }

    public static class Groups {
        public static final String DEFAULT = Registries.getLocationString("default");
        public static final String ACCESSORIES = Registries.getLocationString("accessories");
        public static final String BOOSTERS = Registries.getLocationString("boosters");
    }
}

