/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories;

import com.majruszsaccessories.Integration;
import com.majruszsaccessories.accessories.AccessoryItem;
import com.majruszsaccessories.boosters.BoosterItem;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.math.Range;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class AccessoryHolder {
    public static final Range<Float> BONUS_RANGE = new Range((Number)Float.valueOf(-0.6f), (Number)Float.valueOf(0.6f));
    final ItemStack itemStack;
    final AccessoryItem item;

    public static AccessoryHolder find(LivingEntity entity, Predicate<ItemStack> predicate) {
        if (entity != null) {
            if (Integration.isCuriosInstalled()) {
                Optional slotResult = CuriosApi.getCuriosHelper().findFirstCurio(entity, predicate);
                if (slotResult.isPresent()) {
                    return new AccessoryHolder(((SlotResult)slotResult.get()).stack());
                }
            } else {
                ItemStack itemStack = entity.m_21206_();
                if (predicate.test(itemStack)) {
                    return new AccessoryHolder(itemStack);
                }
            }
        }
        return new AccessoryHolder(ItemStack.f_41583_);
    }

    public static AccessoryHolder find(LivingEntity entity, AccessoryItem item) {
        return AccessoryHolder.find(entity, (ItemStack itemStack) -> itemStack.m_150930_((Item)item));
    }

    public static AccessoryHolder find(LivingEntity entity, BoosterItem item) {
        return AccessoryHolder.find(entity, (ItemStack itemStack) -> AccessoryHolder.create(itemStack).hasBoosterTag(item));
    }

    public static boolean hasAccessory(LivingEntity entity, AccessoryItem item) {
        return AccessoryHolder.find(entity, item).isValid();
    }

    public static boolean hasBooster(LivingEntity entity, BoosterItem item) {
        return AccessoryHolder.find(entity, item).isValid();
    }

    public static AccessoryHolder create(AccessoryItem item) {
        return new AccessoryHolder(new ItemStack((ItemLike)item));
    }

    public static AccessoryHolder create(ItemStack itemStack) {
        return new AccessoryHolder(itemStack);
    }

    public static ChatFormatting getBonusFormatting(float bonus) {
        if (bonus == ((Float)AccessoryHolder.BONUS_RANGE.to).floatValue()) {
            return ChatFormatting.GOLD;
        }
        if (bonus >= 0.0f) {
            return ChatFormatting.GREEN;
        }
        return ChatFormatting.RED;
    }

    public static Rarity getItemRarity(float bonus) {
        if (bonus == ((Float)AccessoryHolder.BONUS_RANGE.to).floatValue()) {
            return Rarity.EPIC;
        }
        if (bonus >= 0.0f) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public static float randomBonus() {
        float gaussianRandom = (float)Mth.m_14008_((double)(Random.nextGaussian() / 4.0), (double)-1.0, (double)1.0);
        float ratio = (gaussianRandom + 1.0f) / 2.0f;
        return Mth.m_14179_((float)ratio, (float)((Float)AccessoryHolder.BONUS_RANGE.from).floatValue(), (float)((Float)AccessoryHolder.BONUS_RANGE.to).floatValue());
    }

    private AccessoryHolder(ItemStack itemStack) {
        AccessoryItem item;
        this.itemStack = itemStack;
        Item item2 = itemStack.m_41720_();
        this.item = item2 instanceof AccessoryItem ? (item = (AccessoryItem)item2) : null;
    }

    public AccessoryHolder copy() {
        AccessoryHolder copy = new AccessoryHolder(new ItemStack((ItemLike)this.item));
        copy.setBonus(this.getBonus());
        return copy;
    }

    public int apply(IntegerConfig config, int multiplier) {
        return (Integer)config.getRange().clamp((Number)Math.round((1.0f + (float)multiplier * this.getBonus()) * (float)((Integer)config.get()).intValue()));
    }

    public int apply(IntegerConfig config) {
        return this.apply(config, 1);
    }

    public float apply(DoubleConfig config, double multiplier) {
        return ((Double)config.getRange().clamp((Number)((1.0 + multiplier * (double)this.getBonus()) * (double)config.asFloat()))).floatValue();
    }

    public float apply(DoubleConfig config) {
        return this.apply(config, 1.0);
    }

    public AccessoryHolder setRandomBonus() {
        if (this.hasBonusRangeTag()) {
            float minBonus = this.getFloatTag("ValueMin");
            float maxBonus = this.getFloatTag("ValueMax");
            return this.setTagValue("Value", Mth.m_14179_((float)Random.nextFloat((float)0.0f, (float)1.0f), (float)minBonus, (float)maxBonus));
        }
        return this.setTagValue("Value", AccessoryHolder.randomBonus());
    }

    public AccessoryHolder setBonus(float bonus) {
        return this.setTagValue("Value", bonus);
    }

    public AccessoryHolder setBonus(Range<Float> bonus) {
        if (((Float)bonus.to).floatValue() - ((Float)bonus.from).floatValue() > 1.0E-5f) {
            return this.setTagValue("ValueMin", ((Float)bonus.from).floatValue()).setTagValue("ValueMax", ((Float)bonus.to).floatValue());
        }
        return this.setBonus(((Float)bonus.from).floatValue());
    }

    public AccessoryHolder setBooster(BoosterItem item) {
        return this.setTagValue("Booster", Utility.getRegistryString((Item)item));
    }

    public float getBonus() {
        return this.getFloatTag("Value");
    }

    public Range<Float> getBonusRange() {
        return new Range((Number)Float.valueOf(this.getFloatTag("ValueMin")), (Number)Float.valueOf(this.getFloatTag("ValueMax")));
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public AccessoryItem getItem() {
        return this.item;
    }

    public BoosterItem getBooster() {
        return (BoosterItem)Utility.getItem((String)this.getStringTag("Booster"));
    }

    public ChatFormatting getBonusFormatting() {
        return AccessoryHolder.getBonusFormatting(this.getBonus());
    }

    public Rarity getItemRarity() {
        return AccessoryHolder.getItemRarity(this.getBonus());
    }

    public boolean isValid() {
        return this.item != null;
    }

    public boolean hasBonusTag() {
        CompoundTag tag = this.itemStack.m_41737_("Bonus");
        return tag != null && tag.m_128441_("Value");
    }

    public boolean hasBonusRangeTag() {
        CompoundTag tag = this.itemStack.m_41737_("Bonus");
        return tag != null && tag.m_128441_("ValueMin") && tag.m_128441_("ValueMax");
    }

    public boolean hasMaxBonus() {
        return this.getBonus() == ((Float)AccessoryHolder.BONUS_RANGE.to).floatValue();
    }

    public boolean hasBoosterTag(BoosterItem item) {
        return Utility.getRegistryString((Item)item).equals(this.getStringTag("Booster"));
    }

    public boolean hasBoosterTag() {
        return !this.getStringTag("Booster").isEmpty();
    }

    private AccessoryHolder setTagValue(String tag, float value) {
        this.itemStack.m_41698_("Bonus").m_128350_(tag, (float)Math.round(100.0f * value) / 100.0f);
        return this;
    }

    private AccessoryHolder setTagValue(String tag, String value) {
        this.itemStack.m_41698_("Bonus").m_128359_(tag, value);
        return this;
    }

    private float getFloatTag(String tag) {
        CompoundTag itemTag = this.itemStack.m_41737_("Bonus");
        return itemTag != null ? itemTag.m_128457_(tag) : 0.0f;
    }

    private String getStringTag(String tag) {
        CompoundTag itemTag = this.itemStack.m_41737_("Bonus");
        return itemTag != null ? itemTag.m_128461_(tag) : "";
    }

    static final class Tags {
        static final String BONUS = "Bonus";
        static final String VALUE = "Value";
        static final String VALUE_MIN = "ValueMin";
        static final String VALUE_MAX = "ValueMax";
        static final String BOOSTER = "Booster";

        Tags() {
        }
    }
}

