/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.mino;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.logic.mino.LogicMinoYellow;
import mod.casinocraft.menu.MenuCasino;
import mod.casinocraft.screen.ScreenCasino;
import mod.casinocraft.util.ButtonMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ScreenMinoYellow
extends ScreenCasino {
    private final int diceColor;

    public ScreenMinoYellow(MenuCasino container, Inventory player, Component name) {
        super(container, player, name);
        Random rand = new Random();
        this.diceColor = rand.nextInt(8);
    }

    public LogicMinoYellow logic() {
        return (LogicMinoYellow)((MenuCasino)this.f_97732_).logic();
    }

    @Override
    protected String getGameName() {
        return "sicbo";
    }

    @Override
    protected void createGameButtons() {
        this.buttonSet.addButton(ButtonMap.POS_BOT_MIDDLE, ButtonMap.PLACE, () -> this.logic().turnstate == 2 && !this.logic().hasPlaced, () -> this.action(-1));
        this.buttonSet.addButton(ButtonMap.POS_BOT_LEFT, ButtonMap.ANOTHER, () -> this.logic().turnstate == 2 && this.logic().hasPlaced && this.playerToken >= this.bet, () -> {
            this.action(-2);
            this.collectBet();
        });
        this.buttonSet.addButton(ButtonMap.POS_BOT_RIGHT, ButtonMap.WAIT, () -> this.logic().turnstate == 2 && this.logic().hasPlaced, () -> this.action(-3));
    }

    @Override
    protected void interact(double mouseX, double mouseY, int mouseButton) {
        if (this.logic().turnstate == 2 && !this.logic().hasPlaced) {
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < 12; ++x) {
                    int sizeY;
                    int sizeX;
                    int posY;
                    int posX = this.tableID == 1 ? 32 + 16 * x : -64 + 32 * x;
                    if (!this.mouseRect(posX, posY = 32 + 32 * y, sizeX = this.tableID == 1 ? 16 : 32, sizeY = 32, mouseX, mouseY)) continue;
                    this.action(x + y * 12);
                }
            }
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack matrix, int mouseX, int mouseY) {
        if (this.logic().turnstate == 2) {
            this.drawTimer(matrix);
        }
        if (this.logic().turnstate == 5) {
            this.drawFontCenter(matrix, this.logic().hand, 128, 7, 0xA9A9A9);
        }
    }

    @Override
    protected void drawBackgroundLayer(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        if (this.tableID == 1) {
            this.drawBackground(matrix, CasinoKeeper.TEXTURE_SICBO_MIDDLE);
        } else {
            this.drawBackground(matrix, CasinoKeeper.TEXTURE_SICBO_LEFT, -128);
            this.drawBackground(matrix, CasinoKeeper.TEXTURE_SICBO_RIGHT, 128);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_DICE);
        int color = 0;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 12; ++x) {
                color = this.logic().grid[x][y];
                int posX = this.tableID == 1 ? 24 + 16 * x : -64 + 32 * x;
                int posY = 32 + 32 * y;
                if (color == -1) {
                    this.m_93228_(matrix, this.f_97735_ + posX, this.f_97736_ + posY, 224, 224, 32, 32);
                }
                if (color > 0) {
                    this.m_93228_(matrix, this.f_97735_ + posX, this.f_97736_ + posY, 192, 32 * color, 32, 32);
                }
                if (!this.logic().selector.matches(x, y)) continue;
                this.m_93228_(matrix, this.f_97735_ + posX, this.f_97736_ + posY, 224, 0, 32, 32);
            }
        }
        if (this.logic().turnstate == 3) {
            this.m_93228_(matrix, this.f_97735_ + this.logic().dice[0].posX, this.f_97736_ + this.logic().dice[0].posY, this.logic().dice[0].number * 32, this.diceColor * 32, 32, 32);
            this.m_93228_(matrix, this.f_97735_ + this.logic().dice[1].posX, this.f_97736_ + this.logic().dice[1].posY, this.logic().dice[1].number * 32, this.diceColor * 32, 32, 32);
            this.m_93228_(matrix, this.f_97735_ + this.logic().dice[2].posX, this.f_97736_ + this.logic().dice[2].posY, this.logic().dice[2].number * 32, this.diceColor * 32, 32, 32);
        }
    }
}

