/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.mino;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.logic.mino.LogicMinoOrange;
import mod.casinocraft.menu.MenuCasino;
import mod.casinocraft.screen.ScreenCasino;
import mod.casinocraft.util.ButtonMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ScreenMinoOrange
extends ScreenCasino {
    private final int diceColor;

    public ScreenMinoOrange(MenuCasino container, Inventory player, Component name) {
        super(container, player, name);
        Random rand = new Random();
        this.diceColor = rand.nextInt(8);
    }

    public LogicMinoOrange logic() {
        return (LogicMinoOrange)((MenuCasino)this.f_97732_).logic();
    }

    @Override
    protected String getGameName() {
        return "craps";
    }

    @Override
    protected void createGameButtons() {
        this.buttonSet.addButton(ButtonMap.POS_BOT_MIDDLE, ButtonMap.PLACE, () -> this.isActivePlayer() && this.logic().turnstate == 2 && !this.logic().hasPlaced, () -> this.action(-1));
        this.buttonSet.addButton(ButtonMap.POS_BOT_LEFT, ButtonMap.ANOTHER, () -> this.isActivePlayer() && this.logic().turnstate == 2 && this.logic().hasPlaced && this.playerToken >= this.bet, () -> {
            this.action(-2);
            this.collectBet();
        });
        this.buttonSet.addButton(ButtonMap.POS_BOT_RIGHT, ButtonMap.WAIT, () -> this.isActivePlayer() && this.logic().turnstate == 2 && this.logic().hasPlaced, () -> this.action(-3));
    }

    @Override
    protected void interact(double mouseX, double mouseY, int mouseButton) {
        if (this.logic().turnstate == 2 && !this.logic().hasPlaced) {
            for (int y = 0; y < 5; ++y) {
                for (int x = 0; x < 8; ++x) {
                    int posX = this.tableID == 1 ? (x == 0 ? 48 : (x == 7 ? 176 : 80 + 16 * (x - 1))) : (x == 0 ? -48 : (x == 7 ? 272 : -16 + 48 * (x - 1)));
                    int posY = 48 + 32 * y;
                    int sizeX = this.tableID == 1 ? (x == 0 ? 32 : (x == 7 ? 32 : 16)) : (x == 0 ? 32 : (x == 7 ? 32 : 48));
                    int sizeY = 32;
                    if (!this.mouseRect(posX, posY, sizeX, sizeY, mouseX, mouseY)) continue;
                    this.action(x + y * 8);
                }
            }
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack matrix, int mouseX, int mouseY) {
        this.drawFontCenter(matrix, this.logic().hand, 128, 7, 0xA9A9A9);
        if (this.logic().result > -1) {
            this.drawFont(matrix, "" + this.logic().result, 10, 7, 0xA9A9A9);
        }
        if (this.logic().point > -1) {
            this.drawFont(matrix, "" + this.logic().point, 25, 7, 0xA9A9A9);
        }
        if (this.logic().comepoint > -1) {
            this.drawFont(matrix, "" + this.logic().comepoint, 40, 7, 0xA9A9A9);
        }
        if (this.logic().turnstate == 2) {
            this.drawTimer(matrix);
        }
    }

    @Override
    protected void drawBackgroundLayer(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        if (this.tableID == 1) {
            this.drawBackground(matrix, CasinoKeeper.TEXTURE_CRAPS_MIDDLE);
        } else {
            this.drawBackground(matrix, CasinoKeeper.TEXTURE_CRAPS_LEFT, -128);
            this.drawBackground(matrix, CasinoKeeper.TEXTURE_CRAPS_RIGHT, 128);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_DICE);
        int color = 0;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 8; ++x) {
                int posX = this.tableID == 1 ? (x == 0 ? 48 : (x == 7 ? 176 : 72 + 16 * (x - 1))) : (x == 0 ? -48 : (x == 7 ? 272 : -8 + 48 * (x - 1)));
                int posY = 48 + 32 * y;
                color = this.logic().grid[x][y];
                if (color == -1) {
                    this.m_93228_(matrix, this.f_97735_ + posX, this.f_97736_ + posY, 224, 224, 32, 32);
                }
                if (color > 0) {
                    this.m_93228_(matrix, this.f_97735_ + posX, this.f_97736_ + posY, 192, 32 * (color % 10), 32, 32);
                }
                if (!this.logic().selector.matches(x, y)) continue;
                this.m_93228_(matrix, this.f_97735_ + posX, this.f_97736_ + posY, 224, 0, 32, 32);
            }
        }
        if (this.logic().turnstate == 3) {
            this.m_93228_(matrix, this.f_97735_ + this.logic().dice[0].posX, this.f_97736_ + this.logic().dice[0].posY, this.logic().dice[0].number * 32, this.diceColor * 32, 32, 32);
            this.m_93228_(matrix, this.f_97735_ + this.logic().dice[1].posX, this.f_97736_ + this.logic().dice[1].posY, this.logic().dice[1].number * 32, this.diceColor * 32, 32, 32);
        }
    }
}

