/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.mino;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.logic.mino.LogicMinoLightGray;
import mod.casinocraft.menu.MenuCasino;
import mod.casinocraft.screen.ScreenCasino;
import mod.casinocraft.util.ButtonMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ScreenMinoLightGray
extends ScreenCasino {
    public ScreenMinoLightGray(MenuCasino container, Inventory player, Component name) {
        super(container, player, name);
    }

    public LogicMinoLightGray logic() {
        return (LogicMinoLightGray)((MenuCasino)this.f_97732_).logic();
    }

    @Override
    protected String getGameName() {
        return "mine_sweeper";
    }

    @Override
    protected void createGameButtons() {
        this.buttonSet.addButton(ButtonMap.POS_MID_LEFT, ButtonMap.CONTINUE, () -> this.isActivePlayer() && this.logic().turnstate == 3, () -> this.action(-1));
        this.buttonSet.addButton(ButtonMap.POS_MID_RIGHT, ButtonMap.GIVEUP, () -> this.isActivePlayer() && this.logic().turnstate == 3, () -> this.action(-2));
    }

    @Override
    protected void interact(double mouseX, double mouseY, int mouseButton) {
        if (this.logic().turnstate == 2) {
            for (int y = 0; y < 14; ++y) {
                for (int x = 0; x < 26; ++x) {
                    if (mouseButton == 0 && this.mouseRect(-80 + 16 * x, 16 + 16 * y, 16, 16, mouseX, mouseY)) {
                        this.action(x + y * 26);
                    }
                    if (mouseButton != 1 || !this.mouseRect(-80 + 16 * x, 16 + 16 * y, 16, 16, mouseX, mouseY)) continue;
                    this.action(x + y * 26 + 1000);
                }
            }
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack matrix, int mouseX, int mouseY) {
        this.drawValueLeft(matrix, "POINTS", this.logic().scorePoint);
        this.drawValueRight(matrix, "BOMBS", this.logic().bombs);
    }

    @Override
    protected void drawBackgroundLayer(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)CasinoKeeper.TEXTURE_MINOS);
        for (int y = 0; y < 14; ++y) {
            for (int x = 0; x < 26; ++x) {
                int i = this.logic().grid[x][y];
                if (i >= 100) {
                    this.drawMinoSmall(matrix, -80 + 16 * x, 16 + 16 * y, i >= 200 ? 11 : 0, false);
                    continue;
                }
                if (i == 9) {
                    this.drawMinoSmall(matrix, -80 + 16 * x, 16 + 16 * y, 12, false);
                    continue;
                }
                if (i == 10) {
                    this.drawMinoSmall(matrix, -80 + 16 * x, 16 + 16 * y, 13, false);
                    continue;
                }
                if (i <= 0) continue;
                this.drawMinoSmall(matrix, -80 + 16 * x, 16 + 16 * y, i + 1, true);
            }
        }
    }
}

