/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.mino;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.logic.mino.LogicMinoGray;
import mod.casinocraft.menu.MenuCasino;
import mod.casinocraft.screen.ScreenCasino;
import mod.casinocraft.util.ButtonMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ScreenMinoGray
extends ScreenCasino {
    public ScreenMinoGray(MenuCasino container, Inventory player, Component name) {
        super(container, player, name);
    }

    public LogicMinoGray logic() {
        return (LogicMinoGray)((MenuCasino)this.f_97732_).logic();
    }

    @Override
    protected String getGameName() {
        return "mino_flip";
    }

    @Override
    protected void createGameButtons() {
        this.buttonSet.addButton(ButtonMap.POS_MID_LEFT, ButtonMap.CONTINUE, () -> this.isActivePlayer() && this.logic().turnstate == 3, () -> this.action(-1));
        this.buttonSet.addButton(ButtonMap.POS_MID_RIGHT, ButtonMap.GIVEUP, () -> this.isActivePlayer() && this.logic().turnstate == 3, () -> this.action(-2));
    }

    @Override
    protected void interact(double mouseX, double mouseY, int mouseButton) {
        if (this.logic().turnstate == 2) {
            for (int y = 0; y < 5; ++y) {
                for (int x = 0; x < 5; ++x) {
                    if (mouseButton == 0 && this.mouseRect(44 + 32 * x, 44 + 32 * y, 24, 24, mouseX, mouseY)) {
                        this.action(x + y * 5);
                    }
                    if (mouseButton != 1 || !this.mouseRect(44 + 32 * x, 44 + 32 * y, 24, 24, mouseX, mouseY)) continue;
                    this.action(x + y * 5 + 100);
                }
            }
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack matrix, int mouseX, int mouseY) {
        this.drawValueLeft(matrix, "POINTS", this.logic().scorePoint);
        if (this.logic().turnstate == 2) {
            for (int z = 0; z < 5; ++z) {
                this.drawFont(matrix, "" + this.logic().grid[5][z], 210, 46 + 32 * z);
                this.drawFont(matrix, "" + this.logic().grid[6][z], 210, 58 + 32 * z);
                this.drawFont(matrix, "" + this.logic().grid[z][5], 46 + 32 * z, 210);
                this.drawFont(matrix, "" + this.logic().grid[z][6], 46 + 32 * z, 222);
            }
        }
    }

    @Override
    protected void drawBackgroundLayer(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(matrix, CasinoKeeper.TEXTURE_MINOFLIP, CasinoKeeper.TEXTURE_MINOS);
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                int i = this.logic().grid[x][y];
                if (i >= 100) {
                    this.drawMino(matrix, 44 + 32 * x, 44 + 32 * y, i >= 200 ? 1 : 0, 0);
                    continue;
                }
                if (i == 0) {
                    this.drawMino(matrix, 44 + 32 * x, 44 + 32 * y, 9, 1);
                    continue;
                }
                this.drawMinoSmall(matrix, 48 + 32 * x, 48 + 32 * y, i % 100 + 1, true);
            }
        }
    }
}

