/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.network;

import java.util.function.Supplier;
import mod.casinocraft.blockentity.BlockEntityMachine;
import mod.casinocraft.logic.LogicModule;
import mod.casinocraft.network.MessageStartClient;
import mod.casinocraft.system.CasinoPacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MessageStartServer {
    static String name;
    static int seed;
    static BlockPos pos;

    public MessageStartServer(String name, int seed, BlockPos pos) {
        MessageStartServer.name = name;
        MessageStartServer.seed = seed;
        MessageStartServer.pos = pos;
    }

    public static void encode(MessageStartServer msg, FriendlyByteBuf buf) {
        buf.m_130070_(name);
        buf.writeInt(seed);
        buf.m_130064_(pos);
    }

    public static MessageStartServer decode(FriendlyByteBuf buf) {
        String _name = buf.m_130136_(24);
        int _seed = buf.readInt();
        BlockPos _pos = buf.m_130135_();
        return new MessageStartServer(_name, _seed, _pos);
    }

    public static class Handler {
        public static void handle(MessageStartServer message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                BlockEntityMachine te = (BlockEntityMachine)((NetworkEvent.Context)context.get()).getSender().f_19853_.m_7702_(pos);
                ((LogicModule)te.logic).addPlayer(name);
                if (seed > -1) {
                    ((LogicModule)te.logic).start(seed);
                }
            });
            CasinoPacketHandler.sendToChunk(new MessageStartClient(name, seed, pos), context.get().getSender().f_19853_.m_46745_(pos));
            context.get().setPacketHandled(true);
        }
    }
}

