/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.mino;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicModule;
import mod.casinocraft.util.Card;
import net.minecraft.nbt.CompoundTag;

public class LogicMinoPink
extends LogicModule {
    public List<Card> chips = new ArrayList<Card>();
    private int max_chips;
    private int alpha;
    private boolean chips_up;
    public boolean hasPlaced = false;

    public LogicMinoPink(int tableID) {
        super(tableID, 4, 1);
    }

    @Override
    public void start2() {
        this.chips.clear();
    }

    @Override
    public void command(int action) {
        this.timeout = 0;
        if (action == -3) {
            ++this.activePlayer;
            this.hasPlaced = false;
            if (this.activePlayer >= this.getFirstFreePlayerSlot()) {
                this.turnstate = 3;
                this.spin();
            }
        } else if (action == -2) {
            this.hasPlaced = false;
            boolean temp = false;
            for (int y = 0; y < this.grid[0].length; ++y) {
                for (int x = 0; x < this.grid.length; ++x) {
                    if (this.grid[x][y] != 0) continue;
                    this.selector.set(x, y);
                    temp = true;
                    break;
                }
                if (!temp) {
                    continue;
                }
                break;
            }
        } else if (action == -1) {
            this.hasPlaced = true;
            if (this.selector.X > -1) {
                this.grid[this.selector.X][this.selector.Y] = this.activePlayer + 1;
                this.selector.set(-1, -1);
            }
        } else if (action >= 0 && this.grid[action][0] == 0) {
            this.selector.set(action, 0);
            this.setJingle(3);
        }
    }

    @Override
    public void updateLogic() {
        if (this.turnstate == 2) {
            ++this.timeout;
            if (this.timeout == this.timeoutMAX) {
                if (!this.hasPlaced) {
                    this.command(-1);
                }
                this.command(-3);
            }
        }
        if (this.turnstate == 3) {
            if (this.chips_up) {
                this.chips.add(new Card((this.tableID == 1 ? 32 : -32) + this.RANDOM.nextInt(this.tableID == 1 ? 192 : 320), 64 + this.RANDOM.nextInt(160)));
                if (this.chips.size() == this.max_chips) {
                    this.chips_up = false;
                    this.alpha = 100;
                }
            } else {
                this.alpha -= 20;
                if (this.alpha <= 0) {
                    this.alpha = 100;
                    this.chips.remove(this.chips.size() - 1);
                    this.chips.remove(this.chips.size() - 1);
                    this.chips.remove(this.chips.size() - 1);
                    this.chips.remove(this.chips.size() - 1);
                    if (this.chips.size() <= 4) {
                        this.result();
                    }
                }
            }
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void load2(CompoundTag compound) {
        this.chips = this.loadCardList(compound, 0);
        this.max_chips = compound.m_128451_("maxchips");
        this.alpha = compound.m_128451_("alpha");
        this.chips_up = compound.m_128471_("chipsup");
    }

    @Override
    public CompoundTag save2(CompoundTag compound) {
        this.saveCardList(compound, 0, this.chips);
        compound.m_128405_("maxchips", this.max_chips);
        compound.m_128405_("alpha", this.alpha);
        compound.m_128379_("chipsup", this.chips_up);
        return compound;
    }

    private void spin() {
        this.max_chips = 40 + this.RANDOM.nextInt(60);
        this.chips_up = true;
    }

    private void result() {
        this.turnstate = 4;
        this.hand = "Chips: " + this.chips.size();
        for (int i = 0; i < 4; ++i) {
            if (this.grid[i][0] <= 0) continue;
            int n = this.grid[i][0] - 1;
            this.reward[n] = this.reward[n] + (this.chips.size() == i + 1 ? 4 : 0);
            this.grid[i][0] = this.chips.size() == i + 1 ? this.grid[i][0] : -1;
        }
        if (this.reward[0] > 0 || this.reward[1] > 0 || this.reward[2] > 0 || this.reward[3] > 0 || this.reward[4] > 0 || this.reward[5] > 0) {
            this.setJingle(10);
        }
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return true;
    }

    @Override
    public int getID() {
        return 43;
    }
}

