/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.mino;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mod.casinocraft.logic.LogicModule;
import mod.lucky77.util.Vector2;
import net.minecraft.nbt.CompoundTag;

public class LogicMinoLightGray
extends LogicModule {
    private List<Vector2> FieldList = new ArrayList<Vector2>();
    public int bombs = 0;

    public LogicMinoLightGray(int tableID) {
        super(tableID, 26, 14);
    }

    @Override
    public void start2() {
        this.bombs = 0;
        this.FieldList.clear();
        this.scoreLevel = 1;
        this.fillGrid();
    }

    private void restart() {
        this.turnstate = 2;
        this.FieldList.clear();
        ++this.scoreLevel;
        this.resetGrid();
        this.fillGrid();
    }

    @Override
    public void command(int action) {
        if (action == -1) {
            this.restart();
        } else if (action == -2) {
            this.turnstate = 4;
        } else if (action >= 1000) {
            this.setJingle(3);
            this.mark(action - 1000);
        } else {
            this.setJingle(3);
            this.flip(action);
        }
    }

    @Override
    public void updateLogic() {
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void load2(CompoundTag compound) {
        this.bombs = compound.m_128451_("bombs");
    }

    @Override
    public CompoundTag save2(CompoundTag compound) {
        compound.m_128405_("bombs", this.bombs);
        return compound;
    }

    private void fillGrid() {
        int x;
        this.bombs = this.scoreLevel + this.scoreLevel * this.tableID * 3;
        int max = this.tableID == 1 ? 196 : 364;
        if (this.bombs > (max -= max / 4)) {
            this.bombs = max;
        }
        for (int i = 0; i < this.bombs; ++i) {
            int y;
            x = this.RANDOM.nextInt(this.tableID == 1 ? 14 : 26) + (this.tableID == 1 ? 6 : 0);
            if (this.grid[x][y = this.RANDOM.nextInt(14)] != 9) {
                this.grid[x][y] = 9;
                continue;
            }
            --i;
        }
        for (int y = 0; y < 14; ++y) {
            for (x = this.tableID == 1 ? 6 : 0; x < (this.tableID == 1 ? 20 : 26); ++x) {
                if (this.grid[x][y] != 9) {
                    int count = 0;
                    if (x > 0 && y > 0 && this.grid[x - 1][y - 1] % 100 == 9) {
                        ++count;
                    }
                    if (y > 0 && this.grid[x][y - 1] % 100 == 9) {
                        ++count;
                    }
                    if (x < 25 && y > 0 && this.grid[x + 1][y - 1] % 100 == 9) {
                        ++count;
                    }
                    if (x < 25 && this.grid[x + 1][y] % 100 == 9) {
                        ++count;
                    }
                    if (x < 25 && y < 13 && this.grid[x + 1][y + 1] % 100 == 9) {
                        ++count;
                    }
                    if (y < 13 && this.grid[x][y + 1] % 100 == 9) {
                        ++count;
                    }
                    if (x > 0 && y < 13 && this.grid[x - 1][y + 1] % 100 == 9) {
                        ++count;
                    }
                    if (x <= 0 || this.grid[x - 1][y] % 100 == 9) {
                        // empty if block
                    }
                    this.grid[x][y] = ++count;
                }
                int[] nArray = this.grid[x];
                int n = y;
                nArray[n] = nArray[n] + 100;
            }
        }
    }

    private void flip(int action) {
        int x = action % 26;
        int y = action / 26;
        if (this.grid[x][y] >= 100) {
            this.grid[x][y] = this.grid[x][y] % 100;
            if (this.grid[x][y] == 9) {
                this.grid[x][y] = 10;
                this.uncoverBombs();
                this.turnstate = 4;
                this.scorePoint /= 2;
            } else {
                if (this.grid[x][y] == 0) {
                    this.FieldList.add(new Vector2(x, y));
                    this.uncoverTiles();
                }
                boolean uncoveredAll = true;
                for (int i = 0; i < 14; ++i) {
                    for (int j = 0; j < 26; ++j) {
                        if (this.grid[j][i] % 20 == 9 || this.grid[j][i] < 20) continue;
                        uncoveredAll = false;
                    }
                }
                if (uncoveredAll) {
                    this.turnstate = 3;
                    this.scorePoint += this.bombs;
                }
            }
        }
    }

    private void mark(int action) {
        int x = action % 26;
        int y = action / 26;
        if (this.grid[x][y] >= 200) {
            int[] nArray = this.grid[x];
            int n = y;
            nArray[n] = nArray[n] - 100;
        } else if (this.grid[x][y] >= 100) {
            int[] nArray = this.grid[x];
            int n = y;
            nArray[n] = nArray[n] + 100;
        }
    }

    private void uncoverTiles() {
        while (this.FieldList.size() > 0) {
            boolean temp0 = false;
            Iterator<Vector2> iterator = this.FieldList.iterator();
            if (iterator.hasNext()) {
                boolean temp;
                Vector2 v = iterator.next();
                if (v.X > 0 && v.Y > 0 && this.grid[v.X - 1][v.Y - 1] >= 100) {
                    int[] nArray = this.grid[v.X - 1];
                    int n = v.Y - 1;
                    nArray[n] = nArray[n] % 100;
                    if (this.grid[v.X - 1][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.Y > 0 && this.grid[v.X][v.Y - 1] >= 100) {
                    int[] nArray = this.grid[v.X];
                    int n = v.Y - 1;
                    nArray[n] = nArray[n] % 100;
                    if (this.grid[v.X][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && v.Y > 0 && this.grid[v.X + 1][v.Y - 1] >= 100) {
                    int[] nArray = this.grid[v.X + 1];
                    int n = v.Y - 1;
                    nArray[n] = nArray[n] % 100;
                    if (this.grid[v.X + 1][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && this.grid[v.X + 1][v.Y] >= 100) {
                    int[] nArray = this.grid[v.X + 1];
                    int n = v.Y;
                    nArray[n] = nArray[n] % 100;
                    if (this.grid[v.X + 1][v.Y] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && v.Y < 13 && this.grid[v.X + 1][v.Y + 1] >= 100) {
                    int[] nArray = this.grid[v.X + 1];
                    int n = v.Y + 1;
                    nArray[n] = nArray[n] % 100;
                    if (this.grid[v.X + 1][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.Y < 13 && this.grid[v.X][v.Y + 1] >= 100) {
                    int[] nArray = this.grid[v.X];
                    int n = v.Y + 1;
                    nArray[n] = nArray[n] % 100;
                    if (this.grid[v.X][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X > 0 && v.Y < 13 && this.grid[v.X - 1][v.Y + 1] >= 100) {
                    int[] nArray = this.grid[v.X - 1];
                    int n = v.Y + 1;
                    nArray[n] = nArray[n] % 100;
                    if (this.grid[v.X - 1][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X > 0 && this.grid[v.X - 1][v.Y] >= 100) {
                    int[] nArray = this.grid[v.X - 1];
                    int n = v.Y;
                    nArray[n] = nArray[n] % 100;
                    if (this.grid[v.X - 1][v.Y] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y));
                            temp0 = true;
                            break;
                        }
                    }
                }
            }
            if (temp0) continue;
            this.FieldList.remove(0);
        }
    }

    private void uncoverBombs() {
        for (int y = 0; y < 14; ++y) {
            for (int x = 0; x < 26; ++x) {
                if (this.grid[x][y] % 100 != 9) continue;
                this.grid[x][y] = 9;
            }
        }
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 39;
    }
}

