/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.card;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicModule;
import mod.casinocraft.util.Card;
import net.minecraft.nbt.CompoundTag;

public class LogicCardGray
extends LogicModule {
    public List<Card> cardsP1 = new ArrayList<Card>();
    public List<Card> cardsP2 = new ArrayList<Card>();
    public List<Card> cardsP3 = new ArrayList<Card>();
    public List<Card> cardsP4 = new ArrayList<Card>();
    public List<Card> cardsP5 = new ArrayList<Card>();
    public List<Card> cardsP6 = new ArrayList<Card>();
    public Card[] comCards = new Card[5];
    public boolean[] folded = new boolean[6];
    public int pot = 0;
    public int raisedPlayer = -1;
    public int playerCount = 0;

    public LogicCardGray(int tableID) {
        super(tableID);
    }

    @Override
    public void start2() {
        int i;
        for (i = 0; i < 6; ++i) {
            this.getCards(i).clear();
        }
        for (i = 0; i < 5; ++i) {
            this.comCards[i] = new Card(-1, -1);
        }
        for (i = 0; i < 6; ++i) {
            this.folded[i] = false;
        }
        this.pot = 0;
        this.raisedPlayer = -1;
    }

    @Override
    public void command(int action) {
        if (action == 0) {
            this.call();
        }
        if (action == 1) {
            this.raise();
        }
        if (action == 2) {
            this.check();
        }
        if (action == 3) {
            this.fold();
        }
    }

    @Override
    public void updateLogic() {
        ++this.timeout;
        if (this.turnstate == 2 && this.timeout >= this.timeoutMAX || this.getFirstFreePlayerSlot() == (this.tableID == 1 ? 4 : 6)) {
            this.draw();
        }
        if (this.turnstate == 3) {
            if (this.folded[this.activePlayer]) {
                this.drawAnother();
            }
            if (this.timeout == this.timeoutMAX) {
                this.fold();
            }
            if (this.lastStanding() != -1) {
                this.result();
            }
        }
    }

    @Override
    public void updateMotion() {
        int i;
        for (i = 0; i < 6; ++i) {
            for (Card c : this.getCards(i)) {
                c.update();
            }
        }
        for (i = 0; i < 5; ++i) {
            this.comCards[i].update();
        }
    }

    @Override
    public void load2(CompoundTag compound) {
        this.cardsP1 = this.loadCardList(compound, 0);
        this.cardsP2 = this.loadCardList(compound, 1);
        this.cardsP3 = this.loadCardList(compound, 2);
        this.cardsP4 = this.loadCardList(compound, 3);
        this.cardsP5 = this.loadCardList(compound, 4);
        this.cardsP6 = this.loadCardList(compound, 5);
        this.comCards = this.loadCardArray(compound, 6);
        this.folded[0] = compound.m_128471_("folded0");
        this.folded[1] = compound.m_128471_("folded1");
        this.folded[2] = compound.m_128471_("folded2");
        this.folded[3] = compound.m_128471_("folded3");
        this.folded[4] = compound.m_128471_("folded4");
        this.folded[5] = compound.m_128471_("folded5");
        this.pot = compound.m_128451_("pot");
        this.raisedPlayer = compound.m_128451_("raisedplayer");
    }

    @Override
    public CompoundTag save2(CompoundTag compound) {
        this.saveCardList(compound, 0, this.cardsP1);
        this.saveCardList(compound, 1, this.cardsP2);
        this.saveCardList(compound, 2, this.cardsP3);
        this.saveCardList(compound, 3, this.cardsP4);
        this.saveCardList(compound, 4, this.cardsP5);
        this.saveCardList(compound, 5, this.cardsP6);
        this.saveCardArray(compound, 6, this.comCards);
        compound.m_128379_("folded0", this.folded[0]);
        compound.m_128379_("folded1", this.folded[1]);
        compound.m_128379_("folded2", this.folded[2]);
        compound.m_128379_("folded3", this.folded[3]);
        compound.m_128379_("folded4", this.folded[4]);
        compound.m_128379_("folded5", this.folded[5]);
        compound.m_128405_("pot", this.pot);
        compound.m_128405_("raisedplayer", this.raisedPlayer);
        return compound;
    }

    public List<Card> getCards(int index) {
        switch (index) {
            case 0: {
                return this.cardsP1;
            }
            case 1: {
                return this.cardsP2;
            }
            case 2: {
                return this.cardsP3;
            }
            case 3: {
                return this.cardsP4;
            }
            case 4: {
                return this.cardsP5;
            }
            case 5: {
                return this.cardsP6;
            }
        }
        return this.cardsP1;
    }

    private void draw() {
        this.turnstate = 3;
        this.timeout = 0;
        this.playerCount = this.pot = this.getFirstFreePlayerSlot();
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < this.pot; ++x) {
                this.getCards(x).add(new Card(this.RANDOM, 0, 24, 8 * x + 32 * y, false));
            }
        }
        for (int i = 0; i < 6; ++i) {
            if (i < this.getFirstFreePlayerSlot()) continue;
            this.folded[i] = true;
        }
        this.comCards[0] = new Card(this.RANDOM, 0, -16, 8 * this.pot + 64, false);
        this.comCards[1] = new Card(this.RANDOM, 0, -16, 8 + 8 * this.pot + 64, false);
        this.setJingle(1);
    }

    private void drawAnother() {
        this.timeout = 0;
        this.activePlayer = (this.activePlayer + 1) % this.getFirstFreePlayerSlot();
        if (this.activePlayer == 0 && this.raisedPlayer == -1) {
            for (int i = 0; i < 5; ++i) {
                if (this.comCards[i].number != -1) continue;
                this.comCards[i] = new Card(this.RANDOM, 0, -24, 0, false);
                break;
            }
            if (this.lastStanding() != -1 || this.comCards[4].number != -1) {
                this.result();
            }
        }
        if (this.activePlayer == this.raisedPlayer) {
            this.raisedPlayer = -1;
        }
        this.setJingle(1);
    }

    private int lastStanding() {
        int count = 0;
        int pos = -1;
        for (int i = 0; i < 6; ++i) {
            if (this.folded[i]) continue;
            ++count;
            pos = i;
        }
        return count == 1 ? pos : -1;
    }

    private void call() {
        ++this.pot;
        this.drawAnother();
    }

    private void raise() {
        ++this.pot;
        this.raisedPlayer = this.activePlayer;
        this.drawAnother();
    }

    private void check() {
        this.drawAnother();
    }

    private void fold() {
        this.folded[this.activePlayer] = true;
        this.drawAnother();
    }

    private void result() {
        this.turnstate = 4;
        int lastPlayer = this.lastStanding();
        if (lastPlayer != -1) {
            this.reward[lastPlayer] = this.pot;
        } else {
            int[] finalHand = new int[]{0, 0, 0, 0, 0, 0};
            for (int i = 0; i < 6; ++i) {
                finalHand[i] = this.folded[i] ? 0 : this.sortAndClear(this.getCards(i).get(0), this.getCards(i).get(1), this.comCards[0], this.comCards[1], this.comCards[2], this.comCards[3], this.comCards[4]);
            }
            int winner = 0;
            for (int i = 0; i < 6; ++i) {
                if (finalHand[i] <= finalHand[winner]) continue;
                winner = i;
            }
            this.reward[winner] = this.pot;
            this.hand = this.currentPlayer[winner] + " has won the Game!";
        }
    }

    private int sortAndClear(Card card0, Card card1, Card card2, Card card3, Card card4, Card card5, Card card6) {
        boolean sorted = false;
        Card[] tempCards = new Card[]{new Card(card0), new Card(card1), new Card(card2), new Card(card3), new Card(card4), new Card(card5), new Card(card6)};
        Card temp = new Card(-1, -1);
        while (!sorted) {
            sorted = true;
            for (int i = 0; i < 5; ++i) {
                if (tempCards[i].sortedNumber() <= tempCards[i + 1].sortedNumber()) continue;
                temp.set(tempCards[i]);
                tempCards[i].set(tempCards[i + 1]);
                tempCards[i + 1].set(temp);
                sorted = false;
            }
        }
        return this.clear(tempCards);
    }

    private int clear(Card[] c) {
        if (c[0].number == c[1].number && c[0].number == c[2].number && c[0].number == c[3].number && c[0].number == c[4].number) {
            return 100000 + c[0].sortedNumber();
        }
        if (c[1].number == c[2].number && c[1].number == c[3].number && c[1].number == c[4].number && c[1].number == c[5].number) {
            return 100000 + c[1].sortedNumber();
        }
        if (c[2].number == c[3].number && c[2].number == c[4].number && c[2].number == c[5].number && c[2].number == c[6].number) {
            return 100000 + c[2].sortedNumber();
        }
        if (c[0].number == 9 && c[1].number == 10 && c[2].number == 11 && c[3].number == 12 && c[4].number == 0 && c[0].suit == c[1].suit && c[0].suit == c[2].suit && c[0].suit == c[3].suit && c[0].suit == c[4].suit) {
            return 90000 + c[0].suit;
        }
        if (c[1].number == 9 && c[2].number == 10 && c[3].number == 11 && c[4].number == 12 && c[5].number == 0 && c[1].suit == c[2].suit && c[1].suit == c[3].suit && c[1].suit == c[4].suit && c[1].suit == c[5].suit) {
            return 90000 + c[1].suit;
        }
        if (c[2].number == 9 && c[3].number == 10 && c[4].number == 11 && c[5].number == 12 && c[6].number == 0 && c[2].suit == c[3].suit && c[2].suit == c[4].suit && c[2].suit == c[5].suit && c[2].suit == c[6].suit) {
            return 90000 + c[2].suit;
        }
        if (c[0].number <= 9 && c[0].number + 1 == c[1].number && c[0].number + 2 == c[2].number && c[0].number + 3 == c[3].number && c[0].number + 4 == c[4].number && c[0].suit == c[1].suit && c[0].suit == c[2].suit && c[0].suit == c[3].suit && c[0].suit == c[4].suit) {
            return 80000 + c[0].sortedNumber();
        }
        if (c[1].number <= 9 && c[1].number + 1 == c[2].number && c[1].number + 2 == c[3].number && c[1].number + 3 == c[4].number && c[1].number + 4 == c[5].number && c[1].suit == c[2].suit && c[1].suit == c[3].suit && c[1].suit == c[4].suit && c[1].suit == c[5].suit) {
            return 80000 + c[1].sortedNumber();
        }
        if (c[2].number <= 9 && c[2].number + 1 == c[3].number && c[2].number + 2 == c[4].number && c[2].number + 3 == c[5].number && c[2].number + 4 == c[6].number && c[2].suit == c[3].suit && c[2].suit == c[4].suit && c[2].suit == c[5].suit && c[2].suit == c[6].suit) {
            return 80000 + c[2].sortedNumber();
        }
        if (c[0].number == c[1].number && c[0].number == c[2].number && c[0].number == c[3].number && c[0].number != c[4].number) {
            return 70000 + c[0].sortedNumber();
        }
        if (c[1].number == c[2].number && c[1].number == c[3].number && c[1].number == c[4].number && c[1].number != c[5].number) {
            return 70000 + c[1].sortedNumber();
        }
        if (c[2].number == c[3].number && c[2].number == c[4].number && c[2].number == c[5].number && c[2].number != c[6].number) {
            return 70000 + c[2].sortedNumber();
        }
        if (c[3].number == c[4].number && c[3].number == c[5].number && c[3].number == c[6].number && c[3].number != c[7].number) {
            return 70000 + c[3].sortedNumber();
        }
        if (c[0].number == c[1].number && c[0].number == c[2].number && c[0].number != c[3].number && c[3].number == c[4].number) {
            return 60000 + c[3].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[0].number == c[1].number && c[0].number == c[2].number && c[0].number != c[4].number && c[4].number == c[5].number) {
            return 60000 + c[4].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[0].number == c[1].number && c[0].number == c[2].number && c[0].number != c[5].number && c[5].number == c[6].number) {
            return 60000 + c[5].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[1].number == c[2].number && c[1].number == c[3].number && c[1].number != c[4].number && c[4].number == c[5].number) {
            return 60000 + c[4].sortedNumber() * 100 + c[1].sortedNumber();
        }
        if (c[1].number == c[2].number && c[1].number == c[3].number && c[1].number != c[5].number && c[5].number == c[6].number) {
            return 60000 + c[5].sortedNumber() * 100 + c[1].sortedNumber();
        }
        if (c[2].number == c[3].number && c[2].number == c[4].number && c[2].number != c[5].number && c[5].number == c[6].number) {
            return 60000 + c[5].sortedNumber() * 100 + c[2].sortedNumber();
        }
        if (c[2].number == c[3].number && c[2].number == c[4].number && c[2].number != c[0].number && c[0].number == c[1].number) {
            return 60000 + c[2].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[3].number == c[4].number && c[3].number == c[5].number && c[3].number != c[0].number && c[0].number == c[1].number) {
            return 60000 + c[3].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[3].number == c[4].number && c[3].number == c[5].number && c[3].number != c[1].number && c[1].number == c[2].number) {
            return 60000 + c[3].sortedNumber() * 100 + c[1].sortedNumber();
        }
        if (c[4].number == c[5].number && c[4].number == c[6].number && c[4].number != c[0].number && c[0].number == c[1].number) {
            return 60000 + c[4].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[4].number == c[5].number && c[4].number == c[6].number && c[4].number != c[1].number && c[1].number == c[2].number) {
            return 60000 + c[4].sortedNumber() * 100 + c[1].sortedNumber();
        }
        if (c[4].number == c[5].number && c[4].number == c[6].number && c[4].number != c[2].number && c[2].number == c[3].number) {
            return 60000 + c[4].sortedNumber() * 100 + c[2].sortedNumber();
        }
        if (c[0].suit == c[1].suit && c[0].suit == c[2].suit && c[0].suit == c[3].suit && c[0].suit == c[4].suit) {
            return 50000 + c[0].sortedNumber();
        }
        if (c[1].suit == c[2].suit && c[1].suit == c[3].suit && c[1].suit == c[4].suit && c[1].suit == c[5].suit) {
            return 50000 + c[1].sortedNumber();
        }
        if (c[2].suit == c[3].suit && c[2].suit == c[4].suit && c[2].suit == c[5].suit && c[2].suit == c[6].suit) {
            return 50000 + c[2].sortedNumber();
        }
        if (c[0].number <= 9 && c[0].number + 1 == c[1].number && c[0].number + 2 == c[2].number && c[0].number + 3 == c[3].number && c[0].number + 4 == c[4].number) {
            return 40000 + c[0].sortedNumber();
        }
        if (c[1].number <= 9 && c[1].number + 1 == c[2].number && c[1].number + 2 == c[3].number && c[1].number + 3 == c[4].number && c[1].number + 4 == c[5].number) {
            return 40000 + c[1].sortedNumber();
        }
        if (c[2].number <= 9 && c[2].number + 1 == c[3].number && c[2].number + 2 == c[4].number && c[2].number + 3 == c[5].number && c[2].number + 4 == c[6].number) {
            return 40000 + c[2].sortedNumber();
        }
        if (c[0].number == c[1].number && c[0].number == c[2].number && c[0].number != c[3].number && c[0].number != c[4].number) {
            return 30000 + c[1].sortedNumber() * 100 + c[6].sortedNumber();
        }
        if (c[1].number == c[2].number && c[1].number == c[3].number && c[1].number != c[4].number && c[1].number != c[5].number) {
            return 30000 + c[2].sortedNumber() * 100 + c[6].sortedNumber();
        }
        if (c[2].number == c[3].number && c[2].number == c[4].number && c[2].number != c[5].number && c[2].number != c[6].number) {
            return 30000 + c[3].sortedNumber() * 100 + c[6].sortedNumber();
        }
        if (c[3].number == c[4].number && c[3].number == c[5].number && c[3].number != c[6].number && c[3].number != c[0].number) {
            return 30000 + c[4].sortedNumber() * 100 + c[6].sortedNumber();
        }
        if (c[4].number == c[5].number && c[4].number == c[6].number && c[4].number != c[0].number && c[4].number != c[1].number) {
            return 30000 + c[5].sortedNumber() * 100 + c[1].sortedNumber();
        }
        if (c[0].number == c[1].number && c[2].number == c[3].number) {
            return 20000 + c[2].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[0].number == c[1].number && c[3].number == c[4].number) {
            return 20000 + c[3].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[0].number == c[1].number && c[4].number == c[5].number) {
            return 20000 + c[4].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[0].number == c[1].number && c[5].number == c[6].number) {
            return 20000 + c[5].sortedNumber() * 100 + c[0].sortedNumber();
        }
        if (c[1].number == c[2].number && c[3].number == c[4].number) {
            return 20000 + c[3].sortedNumber() * 100 + c[1].sortedNumber();
        }
        if (c[1].number == c[2].number && c[4].number == c[5].number) {
            return 20000 + c[4].sortedNumber() * 100 + c[1].sortedNumber();
        }
        if (c[1].number == c[2].number && c[5].number == c[6].number) {
            return 20000 + c[5].sortedNumber() * 100 + c[1].sortedNumber();
        }
        if (c[2].number == c[3].number && c[4].number == c[5].number) {
            return 20000 + c[4].sortedNumber() * 100 + c[2].sortedNumber();
        }
        if (c[2].number == c[3].number && c[5].number == c[6].number) {
            return 20000 + c[5].sortedNumber() * 100 + c[2].sortedNumber();
        }
        if (c[3].number == c[4].number && c[5].number == c[6].number) {
            return 20000 + c[5].sortedNumber() * 100 + c[3].sortedNumber();
        }
        if (c[0].number == c[1].number) {
            return 10000 + c[0].sortedNumber() + c[6].sortedNumber();
        }
        if (c[1].number == c[2].number) {
            return 10000 + c[1].sortedNumber() + c[6].sortedNumber();
        }
        if (c[2].number == c[3].number) {
            return 10000 + c[2].sortedNumber() + c[6].sortedNumber();
        }
        if (c[3].number == c[4].number) {
            return 10000 + c[3].sortedNumber() + c[6].sortedNumber();
        }
        if (c[4].number == c[5].number) {
            return 10000 + c[4].sortedNumber() + c[6].sortedNumber();
        }
        if (c[5].number == c[6].number) {
            return 10000 + c[5].sortedNumber() + c[4].sortedNumber();
        }
        int highestNumber = 0;
        for (int i = 0; i < 7; ++i) {
            if (c[i].sortedNumber() <= highestNumber) continue;
            highestNumber = c[i].sortedNumber();
        }
        return highestNumber;
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return true;
    }

    @Override
    public int getID() {
        return 4;
    }
}

