/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.block;

import javax.annotation.Nullable;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.blockentity.BlockEntityMachine;
import mod.casinocraft.blockentity.BlockEntitySlotMachine;
import mod.lucky77.block.MachinaTall;
import mod.lucky77.blockentity.BlockEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.NetworkHooks;

public class BlockSlotMachine
extends MachinaTall
implements EntityBlock {
    private DyeColor color;
    private static final VoxelShape AABB0 = Block.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape AABB1 = Block.m_49796_((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB2 = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)10.0, (double)16.0, (double)14.0);
    private static final VoxelShape AABB3 = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)10.0);

    public BlockSlotMachine(Block block, DyeColor color) {
        super(block);
        this.color = color;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean isPrimary = (Boolean)state.m_61143_((Property)OFFSET);
        BlockEntityMachine tile = (BlockEntityMachine)world.m_7702_(this.getTilePosition(pos, isPrimary, Direction.DOWN));
        if (tile != null && tile.settingDropItemsOnBreak) {
            tile.m_6836_(3, new ItemStack((ItemLike)tile.m_8020_(3).m_41720_(), tile.storageToken));
            tile.m_6836_(4, new ItemStack((ItemLike)tile.m_8020_(4).m_41720_(), tile.storageToken));
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void interact(Level world, BlockPos pos, Player player, BlockEntityBase tile) {
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new mod.casinocraft.menu.MenuProvider((BlockEntityMachine)tile), buf -> buf.m_130064_(pos));
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction enumfacing = (Direction)state.m_61143_((Property)FACING);
        switch (enumfacing) {
            case NORTH: {
                return AABB1;
            }
            case SOUTH: {
                return AABB3;
            }
            case EAST: {
                return AABB2;
            }
            case WEST: {
                return AABB0;
            }
        }
        return Shapes.m_83144_();
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        BlockPos pos2 = this.getTilePosition(pos, (Boolean)state.m_61143_((Property)OFFSET), Direction.DOWN);
        BlockEntityMachine tileEntity = (BlockEntityMachine)worldIn.m_7702_(pos2);
        boolean unbreakable = tileEntity.settingIndestructableBlock;
        float f = state.m_60800_(worldIn, pos);
        if (unbreakable) {
            f *= 1000.0f;
        }
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        BlockPos pos2 = this.getTilePosition(pos, (Boolean)state.m_61143_((Property)OFFSET), Direction.DOWN);
        BlockEntityMachine tileEntity = (BlockEntityMachine)world.m_7702_(pos2);
        boolean unbreakable = tileEntity.settingIndestructableBlock;
        return this.m_7374_().m_7325_() * (float)(unbreakable ? 1000 : 1);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)OFFSET) != false ? new BlockEntitySlotMachine(pos, state, this.color, 3) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockSlotMachine.createTicker(level, type, (BlockEntityType<? extends BlockEntitySlotMachine>)((BlockEntityType)CasinoKeeper.TILE_ARCADE_SLOT.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends BlockEntitySlotMachine> typeCustom) {
        return BlockSlotMachine.createTickerHelper(type, typeCustom, BlockEntityMachine::serverTick);
    }
}

