/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class ChunkSchematic
extends LevelChunk {
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private final Int2ObjectOpenHashMap<List<Entity>> entityLists = new Int2ObjectOpenHashMap();
    private final long timeCreated;
    private final int bottomY;
    private final int topY;
    private int entityCount;
    private boolean isEmpty = true;

    public ChunkSchematic(Level worldIn, ChunkPos pos) {
        super(worldIn, pos);
        this.timeCreated = worldIn.m_46467_();
        this.bottomY = worldIn.m_141937_();
        this.topY = worldIn.m_151558_();
    }

    public BlockState m_8055_(BlockPos pos) {
        LevelChunkSection chunkSection;
        int x = pos.m_123341_() & 0xF;
        int y = pos.m_123342_();
        int z = pos.m_123343_() & 0xF;
        int cy = this.m_151564_(y);
        y &= 0xF;
        LevelChunkSection[] sections = this.m_7103_();
        if (cy >= 0 && cy < sections.length && !(chunkSection = sections[cy]).m_188008_()) {
            return chunkSection.m_62982_(x, y, z);
        }
        return AIR;
    }

    public BlockState m_6978_(BlockPos pos, BlockState state, boolean isMoving) {
        BlockEntity te;
        BlockState stateOld = this.m_8055_(pos);
        int y = pos.m_123342_();
        if (stateOld == state || y >= this.topY || y < this.bottomY) {
            return null;
        }
        int x = pos.m_123341_() & 0xF;
        int z = pos.m_123343_() & 0xF;
        int cy = this.m_151564_(y);
        Block blockNew = state.m_60734_();
        Block blockOld = stateOld.m_60734_();
        LevelChunkSection section = this.m_7103_()[cy];
        if (section.m_188008_() && state.m_60795_()) {
            return null;
        }
        y &= 0xF;
        if (!state.m_60795_()) {
            this.isEmpty = false;
        }
        section.m_62986_(x, y, z, state);
        if (blockOld != blockNew) {
            this.m_62953_().m_46747_(pos);
        }
        if (section.m_62982_(x, y, z).m_60734_() != blockNew) {
            return null;
        }
        if (state.m_155947_() && blockNew instanceof EntityBlock && (te = this.m_5685_(pos, LevelChunk.EntityCreationType.CHECK)) == null && (te = ((EntityBlock)blockNew).m_142194_(pos, state)) != null) {
            this.m_62953_().m_46745_(pos).m_142169_(te);
        }
        this.m_6344_();
        return stateOld;
    }

    public void m_6286_(Entity entity) {
        int chunkY = Mth.m_14107_((double)entity.m_20186_()) >> 4;
        List list = (List)this.entityLists.computeIfAbsent(chunkY, y -> new ArrayList());
        list.add(entity);
        ++this.entityCount;
    }

    public List<Entity> getEntityListForSectionIfExists(int sectionY) {
        return (List)this.entityLists.getOrDefault(sectionY, Collections.emptyList());
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public boolean m_6430_() {
        return this.isEmpty;
    }
}

