/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.placement;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.SchematicHolder;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.OverlayRenderer;
import fi.dy.masa.litematica.render.infohud.StatusInfoRenderer;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkCommand;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkDirect;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicSetblockToMcfunction;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.util.SchematicPlacingUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfirmAction;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IConfirmationListener;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerMode;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.SubChunkPos;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SchematicPlacementManager {
    private final List<SchematicPlacement> schematicPlacements = new ArrayList<SchematicPlacement>();
    private final ArrayListMultimap<ChunkPos, SchematicPlacement> schematicsTouchingChunk = ArrayListMultimap.create();
    private final ArrayListMultimap<SubChunkPos, PlacementPart> touchedVolumesInSubChunk = ArrayListMultimap.create();
    private final Long2ObjectOpenHashMap<Set<SubChunkPos>> touchedSubChunksInChunks = new Long2ObjectOpenHashMap();
    private final Set<ChunkPos> chunksToRebuild = new HashSet<ChunkPos>();
    private final Set<ChunkPos> chunkRebuildQueue = new HashSet<ChunkPos>();
    private final LongOpenHashSet chunksToUnload = new LongOpenHashSet();
    private final Set<ChunkPos> chunksPreChange = new HashSet<ChunkPos>();
    private final List<SubChunkPos> visibleSubChunks = new ArrayList<SubChunkPos>();
    private SubChunkPos lastVisibleSubChunksSortPos = new SubChunkPos(0, 0, 0);
    private boolean visibleSubChunksNeedsUpdate;
    @Nullable
    private SchematicPlacement selectedPlacement;

    public boolean hasPendingRebuilds() {
        return !this.chunksToRebuild.isEmpty();
    }

    public boolean hasPendingRebuildFor(ChunkPos pos) {
        return this.chunksToRebuild.contains(pos);
    }

    public void setVisibleSubChunksNeedsUpdate() {
        this.visibleSubChunksNeedsUpdate = true;
    }

    public void processQueuedChunks() {
        if (!this.chunksToUnload.isEmpty()) {
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            if (worldSchematic != null) {
                LongIterator longIterator = this.chunksToUnload.iterator();
                while (longIterator.hasNext()) {
                    long posLong = (Long)longIterator.next();
                    this.unloadSchematicChunk(worldSchematic, ChunkPos.m_45592_((long)posLong), ChunkPos.m_45602_((long)posLong));
                }
            }
            this.chunksToUnload.clear();
        }
        if (!this.chunkRebuildQueue.isEmpty()) {
            ClientLevel worldClient = Minecraft.m_91087_().f_91073_;
            if (worldClient == null) {
                this.chunksToRebuild.clear();
                this.chunkRebuildQueue.clear();
                return;
            }
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            Iterator<ChunkPos> queueIterator = this.chunkRebuildQueue.iterator();
            while (queueIterator.hasNext() && System.nanoTime() - DataManager.getClientTickStartTime() < 50000000L) {
                ChunkPos pos = queueIterator.next();
                if (!this.schematicsTouchingChunk.containsKey((Object)pos)) {
                    queueIterator.remove();
                    this.chunksToRebuild.remove(pos);
                    continue;
                }
                if (Configs.Generic.LOAD_ENTIRE_SCHEMATICS.getBooleanValue() || WorldUtils.isClientChunkLoaded(worldClient, pos.f_45578_, pos.f_45579_)) {
                    this.unloadSchematicChunk(worldSchematic, pos.f_45578_, pos.f_45579_);
                    worldSchematic.getChunkProvider().loadChunk(pos.f_45578_, pos.f_45579_);
                    this.visibleSubChunksNeedsUpdate = true;
                }
                if (worldSchematic.getChunkProvider().m_5563_(pos.f_45578_, pos.f_45579_)) {
                    List placements = this.schematicsTouchingChunk.get((Object)pos);
                    if (!placements.isEmpty()) {
                        for (SchematicPlacement placement : placements) {
                            if (!placement.isEnabled()) continue;
                            SchematicPlacingUtils.placeToWorldWithinChunk(worldSchematic, pos, placement, ReplaceBehavior.WITH_NON_AIR, false);
                        }
                        worldSchematic.scheduleChunkRenders(pos.f_45578_, pos.f_45579_);
                    }
                    this.chunksToRebuild.remove(pos);
                }
                queueIterator.remove();
            }
            LitematicaRenderer.getInstance().getWorldRenderer().markNeedsUpdate();
        }
    }

    public void onClientChunkLoad(int chunkX, int chunkZ) {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        this.chunkRebuildQueue.add(pos);
    }

    public void onClientChunkUnload(int chunkX, int chunkZ) {
        if (!Configs.Generic.LOAD_ENTIRE_SCHEMATICS.getBooleanValue()) {
            this.chunksToUnload.add(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
        }
    }

    private void unloadSchematicChunk(WorldSchematic worldSchematic, int chunkX, int chunkZ) {
        if (worldSchematic.getChunkProvider().m_5563_(chunkX, chunkZ)) {
            worldSchematic.getChunkProvider().unloadChunk(chunkX, chunkZ);
            worldSchematic.scheduleChunkRenders(chunkX, chunkZ);
            this.visibleSubChunksNeedsUpdate = true;
        }
    }

    public List<SubChunkPos> getLastVisibleSubChunks() {
        return this.visibleSubChunks;
    }

    public List<SubChunkPos> getAndUpdateVisibleSubChunks(SubChunkPos viewSubChunk) {
        if (this.visibleSubChunksNeedsUpdate) {
            this.visibleSubChunks.clear();
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            LayerRange range = DataManager.getRenderLayerRange();
            if (worldSchematic != null) {
                LongIterator longIterator = worldSchematic.getChunkManager().getLoadedChunks().keySet().iterator();
                while (longIterator.hasNext()) {
                    long posLong = (Long)longIterator.next();
                    Set subChunks = (Set)this.touchedSubChunksInChunks.get(posLong);
                    if (subChunks == null) continue;
                    for (SubChunkPos subChunk : subChunks) {
                        if (!range.intersects(subChunk)) continue;
                        this.visibleSubChunks.add(subChunk);
                    }
                }
                this.visibleSubChunks.sort((Comparator<SubChunkPos>)new SubChunkPos.DistanceComparator(viewSubChunk));
                this.lastVisibleSubChunksSortPos = viewSubChunk;
            }
            this.visibleSubChunksNeedsUpdate = false;
        } else if (!viewSubChunk.equals((Object)this.lastVisibleSubChunksSortPos)) {
            this.visibleSubChunks.sort((Comparator<SubChunkPos>)new SubChunkPos.DistanceComparator(viewSubChunk));
            this.lastVisibleSubChunksSortPos = viewSubChunk;
        }
        return this.visibleSubChunks;
    }

    public List<SchematicPlacement> getAllSchematicsPlacements() {
        return this.schematicPlacements;
    }

    public List<IntBoundingBox> getTouchedBoxesInSubChunk(SubChunkPos subChunk) {
        ArrayList<IntBoundingBox> list = new ArrayList<IntBoundingBox>();
        for (PlacementPart part : this.touchedVolumesInSubChunk.get((Object)subChunk)) {
            list.add(part.getBox());
        }
        return list;
    }

    public List<PlacementPart> getAllPlacementsTouchingSubChunk(SubChunkPos pos) {
        return this.touchedVolumesInSubChunk.get((Object)pos);
    }

    public Set<SubChunkPos> getAllTouchedSubChunks() {
        return this.touchedVolumesInSubChunk.keySet();
    }

    public void addSchematicPlacement(SchematicPlacement placement, boolean printMessages) {
        if (!this.schematicPlacements.contains(placement)) {
            this.schematicPlacements.add(placement);
            this.addTouchedChunksFor(placement);
            StatusInfoRenderer.getInstance().startOverrideDelay();
            if (printMessages) {
                InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)StringUtils.translate((String)"litematica.message.schematic_placement_created", (Object[])new Object[]{placement.getName()}), (Object[])new Object[0]);
                if (Configs.InfoOverlays.WARN_DISABLED_RENDERING.getBooleanValue()) {
                    String hotkeyVal;
                    String hotkeyName;
                    String configName;
                    ConfigHotkey hotkey;
                    LayerMode mode = DataManager.getRenderLayerRange().getLayerMode();
                    if (mode != LayerMode.ALL) {
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.warn.layer_mode_currently_at", (Object[])new Object[]{mode.getDisplayName()});
                    }
                    if (!Configs.Visuals.ENABLE_RENDERING.getBooleanValue()) {
                        hotkey = Hotkeys.TOGGLE_ALL_RENDERING;
                        configName = Configs.Visuals.ENABLE_RENDERING.getName();
                        hotkeyName = hotkey.getName();
                        hotkeyVal = hotkey.getKeybind().getKeysDisplayString();
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"litematica.message.warn.main_rendering_disabled", (Object[])new Object[]{configName, hotkeyName, hotkeyVal});
                    }
                    if (!Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
                        hotkey = Hotkeys.TOGGLE_SCHEMATIC_RENDERING;
                        configName = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getName();
                        hotkeyName = hotkey.getName();
                        hotkeyVal = hotkey.getKeybind().getKeysDisplayString();
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"litematica.message.warn.schematic_rendering_disabled", (Object[])new Object[]{configName, hotkeyName, hotkeyVal});
                    }
                    if (!Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue()) {
                        hotkey = Hotkeys.TOGGLE_SCHEMATIC_BLOCK_RENDERING;
                        configName = Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getName();
                        hotkeyName = hotkey.getName();
                        hotkeyVal = hotkey.getKeybind().getKeysDisplayString();
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"litematica.message.warn.schematic_blocks_rendering_disabled", (Object[])new Object[]{configName, hotkeyName, hotkeyVal});
                    }
                }
            }
        } else if (printMessages) {
            InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.duplicate_schematic_placement", (Object[])new Object[0]);
        }
    }

    public boolean removeSchematicPlacement(SchematicPlacement placement) {
        return this.removeSchematicPlacement(placement, true);
    }

    public boolean removeSchematicPlacement(SchematicPlacement placement, boolean update) {
        if (this.selectedPlacement == placement) {
            this.selectedPlacement = null;
        }
        boolean ret = this.schematicPlacements.remove(placement);
        this.removeTouchedChunksFor(placement);
        if (ret) {
            placement.onRemoved();
            if (update) {
                this.onPlacementModified(placement);
            }
        }
        return ret;
    }

    public List<SchematicPlacement> getAllPlacementsOfSchematic(LitematicaSchematic schematic) {
        ArrayList<SchematicPlacement> list = new ArrayList<SchematicPlacement>();
        for (SchematicPlacement placement : this.schematicPlacements) {
            if (placement.getSchematic() != schematic) continue;
            list.add(placement);
        }
        return list;
    }

    public void removeAllPlacementsOfSchematic(LitematicaSchematic schematic) {
        boolean removed = false;
        for (int i = 0; i < this.schematicPlacements.size(); ++i) {
            SchematicPlacement placement = this.schematicPlacements.get(i);
            if (placement.getSchematic() != schematic) continue;
            removed |= this.removeSchematicPlacement(placement, false);
            --i;
        }
        if (removed) {
            OverlayRenderer.getInstance().updatePlacementCache();
        }
    }

    @Nullable
    public SchematicPlacement getSelectedSchematicPlacement() {
        return this.selectedPlacement;
    }

    public void setSelectedSchematicPlacement(@Nullable SchematicPlacement placement) {
        if (placement == null || this.schematicPlacements.contains(placement)) {
            this.selectedPlacement = placement;
            OverlayRenderer.getInstance().updatePlacementCache();
            DataManager.setMaterialList(null);
        }
    }

    private void addTouchedChunksFor(SchematicPlacement placement) {
        if (placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED)) {
            Set<ChunkPos> chunks = placement.getTouchedChunks();
            for (ChunkPos pos : chunks) {
                if (!this.schematicsTouchingChunk.containsEntry((Object)pos, (Object)placement)) {
                    this.schematicsTouchingChunk.put((Object)pos, (Object)placement);
                    this.updateTouchedBoxesInChunk(pos);
                }
                this.chunksToUnload.remove(pos.m_45588_());
            }
            this.markChunksForRebuild(placement);
            this.onPlacementModified(placement);
        }
    }

    private void removeTouchedChunksFor(SchematicPlacement placement) {
        if (placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED)) {
            Set<ChunkPos> chunks = placement.getTouchedChunks();
            Iterator<ChunkPos> it = chunks.iterator();
            while (it.hasNext()) {
                ChunkPos pos = it.next();
                this.schematicsTouchingChunk.remove((Object)pos, (Object)placement);
                this.updateTouchedBoxesInChunk(pos);
                if (this.schematicsTouchingChunk.containsKey((Object)pos)) continue;
                this.chunksToUnload.add(pos.m_45588_());
                it.remove();
            }
            this.markChunksForRebuild(chunks);
        }
    }

    void onPrePlacementChange(SchematicPlacement placement) {
        this.chunksPreChange.clear();
        this.chunksPreChange.addAll(placement.getTouchedChunks());
    }

    void onPostPlacementChange(SchematicPlacement placement) {
        Set<ChunkPos> chunksPost = placement.getTouchedChunks();
        HashSet<ChunkPos> toRebuild = new HashSet<ChunkPos>(chunksPost);
        this.chunksPreChange.removeAll(chunksPost);
        for (ChunkPos pos : this.chunksPreChange) {
            this.schematicsTouchingChunk.remove((Object)pos, (Object)placement);
            this.updateTouchedBoxesInChunk(pos);
            if (!this.schematicsTouchingChunk.containsKey((Object)pos)) {
                this.chunksToUnload.add(pos.m_45588_());
                continue;
            }
            toRebuild.add(pos);
        }
        for (ChunkPos pos : chunksPost) {
            if (!this.schematicsTouchingChunk.containsEntry((Object)pos, (Object)placement)) {
                this.schematicsTouchingChunk.put((Object)pos, (Object)placement);
            }
            this.updateTouchedBoxesInChunk(pos);
        }
        this.markChunksForRebuild(toRebuild);
        this.onPlacementModified(placement);
    }

    private void updateTouchedBoxesInChunk(ChunkPos pos) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        int minChunkY = world != null ? world.m_151560_() : -4;
        int maxChunkY = world != null ? world.m_151561_() : 19;
        for (int y = minChunkY; y < maxChunkY; ++y) {
            SubChunkPos subChunk = new SubChunkPos(pos.f_45578_, y, pos.f_45579_);
            this.touchedVolumesInSubChunk.removeAll((Object)subChunk);
        }
        long posLong = pos.m_45588_();
        this.touchedSubChunksInChunks.remove(posLong);
        List placements = this.schematicsTouchingChunk.get((Object)pos);
        if (!placements.isEmpty()) {
            HashSet<SubChunkPos> subChunks = new HashSet<SubChunkPos>();
            for (SchematicPlacement placement : placements) {
                if (!placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.RENDERING_ENABLED)) continue;
                ImmutableMap<String, IntBoundingBox> boxMap = placement.getBoxesWithinChunk(pos.f_45578_, pos.f_45579_);
                for (Map.Entry entry : boxMap.entrySet()) {
                    IntBoundingBox bbOrig = (IntBoundingBox)entry.getValue();
                    int startCY = bbOrig.minY >> 4;
                    int endCY = bbOrig.maxY >> 4;
                    for (int cy = startCY; cy <= endCY; ++cy) {
                        int y1 = Math.max(cy << 4, bbOrig.minY);
                        int y2 = Math.min((cy << 4) + 15, bbOrig.maxY);
                        IntBoundingBox bbSub = new IntBoundingBox(bbOrig.minX, y1, bbOrig.minZ, bbOrig.maxX, y2, bbOrig.maxZ);
                        PlacementPart part = new PlacementPart(placement, (String)entry.getKey(), bbSub);
                        SubChunkPos subPos = new SubChunkPos(pos.f_45578_, cy, pos.f_45579_);
                        this.touchedVolumesInSubChunk.put((Object)subPos, (Object)part);
                        subChunks.add(subPos);
                    }
                }
            }
            this.touchedSubChunksInChunks.put(posLong, subChunks);
        }
    }

    public void markAllPlacementsOfSchematicForRebuild(LitematicaSchematic schematic) {
        for (int i = 0; i < this.schematicPlacements.size(); ++i) {
            SchematicPlacement placement = this.schematicPlacements.get(i);
            if (placement.getSchematic() != schematic) continue;
            this.markChunksForRebuild(placement);
        }
    }

    public void markChunksForRebuild(SchematicPlacement placement) {
        if (placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED)) {
            this.markChunksForRebuild(placement.getTouchedChunks());
        }
    }

    void markChunksForRebuild(Collection<ChunkPos> chunks) {
        this.chunksToRebuild.addAll(chunks);
        this.chunkRebuildQueue.addAll(chunks);
    }

    public void markChunkForRebuild(ChunkPos pos) {
        this.chunksToRebuild.add(pos);
        this.chunkRebuildQueue.add(pos);
    }

    private void onPlacementModified(SchematicPlacement placement) {
        if (placement.isEnabled()) {
            OverlayRenderer.getInstance().updatePlacementCache();
        }
    }

    public boolean changeSelection(Level world, Entity entity, int maxDistance) {
        if (this.schematicPlacements.size() > 0) {
            RayTraceUtils.RayTraceWrapper trace = RayTraceUtils.getWrappedRayTraceFromEntity(world, entity, maxDistance);
            SchematicPlacement placement = this.getSelectedSchematicPlacement();
            if (placement != null) {
                placement.setSelectedSubRegionName(null);
            }
            if (trace.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.PLACEMENT_SUBREGION || trace.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.PLACEMENT_ORIGIN) {
                this.setSelectedSchematicPlacement(trace.getHitSchematicPlacement());
                boolean selectSubRegion = Hotkeys.SELECTION_GRAB_MODIFIER.getKeybind().isKeybindHeld();
                String subRegionName = selectSubRegion ? trace.getHitSchematicPlacementRegionName() : null;
                this.getSelectedSchematicPlacement().setSelectedSubRegionName(subRegionName);
                return true;
            }
            if (trace.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.MISS) {
                this.setSelectedSchematicPlacement(null);
                return true;
            }
        }
        return false;
    }

    public void setPositionOfCurrentSelectionToRayTrace(Minecraft mc, double maxDistance) {
        SchematicPlacement schematicPlacement = this.getSelectedSchematicPlacement();
        if (schematicPlacement != null) {
            Entity entity = fi.dy.masa.malilib.util.EntityUtils.getCameraEntity();
            HitResult trace = RayTraceUtils.getRayTraceFromEntity((Level)mc.f_91073_, entity, false, maxDistance);
            if (trace.m_6662_() != HitResult.Type.BLOCK) {
                return;
            }
            BlockPos pos = ((BlockHitResult)trace).m_82425_();
            if (!mc.f_91074_.m_6144_()) {
                pos = pos.m_142300_(((BlockHitResult)trace).m_82434_());
            }
            this.setPositionOfCurrentSelectionTo(pos, mc);
        }
    }

    public void setPositionOfCurrentSelectionTo(BlockPos pos, Minecraft mc) {
        SchematicPlacement schematicPlacement = this.getSelectedSchematicPlacement();
        if (schematicPlacement != null) {
            boolean movingBox;
            if (schematicPlacement.isLocked()) {
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.placement.cant_modify_is_locked", (Object[])new Object[0]);
                return;
            }
            boolean bl = movingBox = schematicPlacement.getSelectedSubRegionPlacement() != null;
            if (movingBox) {
                schematicPlacement.moveSubRegionTo(schematicPlacement.getSelectedSubRegionName(), pos, InfoUtils.INFO_MESSAGE_CONSUMER);
                String posStr = String.format("x: %d, y: %d, z: %d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.placement.moved_subregion_to", (Object[])new Object[]{posStr});
            } else {
                BlockPos old = schematicPlacement.getOrigin();
                schematicPlacement.setOrigin(pos, InfoUtils.INFO_MESSAGE_CONSUMER);
                if (!old.equals((Object)schematicPlacement.getOrigin())) {
                    String posStrOld = String.format("x: %d, y: %d, z: %d", old.m_123341_(), old.m_123342_(), old.m_123343_());
                    String posStrNew = String.format("x: %d, y: %d, z: %d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.placement.moved_placement_origin", (Object[])new Object[]{posStrOld, posStrNew});
                }
            }
        }
    }

    public void nudgePositionOfCurrentSelection(Direction direction, int amount) {
        SchematicPlacement schematicPlacement = this.getSelectedSchematicPlacement();
        if (schematicPlacement != null) {
            if (schematicPlacement.isLocked()) {
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.placement.cant_modify_is_locked", (Object[])new Object[0]);
                return;
            }
            SubRegionPlacement placement = schematicPlacement.getSelectedSubRegionPlacement();
            if (placement != null) {
                BlockPos old = PositionUtils.getTransformedBlockPos(placement.getPos(), schematicPlacement.getMirror(), schematicPlacement.getRotation());
                old = old.m_141952_((Vec3i)schematicPlacement.getOrigin());
                schematicPlacement.moveSubRegionTo(placement.getName(), old.m_5484_(direction, amount), InfoUtils.INFO_MESSAGE_CONSUMER);
            } else {
                BlockPos old = schematicPlacement.getOrigin();
                schematicPlacement.setOrigin(old.m_5484_(direction, amount), InfoUtils.INFO_MESSAGE_CONSUMER);
            }
        }
    }

    public void pasteCurrentPlacementToWorld(Minecraft mc) {
        this.pastePlacementToWorld(this.getSelectedSchematicPlacement(), mc);
    }

    public void pastePlacementToWorld(SchematicPlacement schematicPlacement, Minecraft mc) {
        this.pastePlacementToWorld(schematicPlacement, true, mc);
    }

    public void pastePlacementToWorld(SchematicPlacement schematicPlacement, boolean changedBlocksOnly, Minecraft mc) {
        this.pastePlacementToWorld(schematicPlacement, changedBlocksOnly, true, mc);
    }

    public void pastePlacementToWorld(SchematicPlacement schematicPlacement, boolean changedBlocksOnly, boolean printMessage, Minecraft mc) {
        if (mc.f_91074_ != null && EntityUtils.isCreativeMode((Player)mc.f_91074_)) {
            if (schematicPlacement != null) {
                LayerRange range = DataManager.getRenderLayerRange();
                if (Configs.Generic.PASTE_TO_MCFUNCTION.getBooleanValue()) {
                    PasteToCommandsListener cl = new PasteToCommandsListener(schematicPlacement, changedBlocksOnly);
                    GuiConfirmAction screen = new GuiConfirmAction(320, "Confirm paste to command files", (IConfirmationListener)cl, null, "Are you sure you want to paste the current placement as setblock commands into command/mcfunction files?", new Object[0]);
                    GuiBase.openGui((Screen)screen);
                } else if (mc.m_91091_()) {
                    TaskPasteSchematicPerChunkDirect task = new TaskPasteSchematicPerChunkDirect(Collections.singletonList(schematicPlacement), range, changedBlocksOnly);
                    TaskScheduler.getInstanceServer().scheduleTask(task, Configs.Generic.COMMAND_TASK_INTERVAL.getIntegerValue());
                    if (printMessage) {
                        InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.INFO, (String)"litematica.message.scheduled_task_added", (Object[])new Object[0]);
                    }
                } else {
                    TaskPasteSchematicPerChunkCommand task = new TaskPasteSchematicPerChunkCommand(Collections.singletonList(schematicPlacement), range, changedBlocksOnly);
                    TaskScheduler.getInstanceClient().scheduleTask(task, Configs.Generic.COMMAND_TASK_INTERVAL.getIntegerValue());
                    if (printMessage) {
                        InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.INFO, (String)"litematica.message.scheduled_task_added", (Object[])new Object[0]);
                    }
                }
            } else {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_placement_selected", (Object[])new Object[0]);
            }
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.generic.creative_mode_only", (Object[])new Object[0]);
        }
    }

    public void clear() {
        this.schematicPlacements.clear();
        this.selectedPlacement = null;
        this.schematicsTouchingChunk.clear();
        this.touchedVolumesInSubChunk.clear();
        this.touchedSubChunksInChunks.clear();
        this.chunksPreChange.clear();
        this.chunksToRebuild.clear();
        this.chunkRebuildQueue.clear();
        this.chunksToUnload.clear();
        SchematicHolder.getInstance().clearLoadedSchematics();
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        if (this.schematicPlacements.size() > 0) {
            JsonArray arr = new JsonArray();
            int selectedIndex = 0;
            boolean indexValid = false;
            for (int i = 0; i < this.schematicPlacements.size(); ++i) {
                JsonObject objPlacement;
                SchematicPlacement placement = this.schematicPlacements.get(i);
                if (!placement.shouldBeSaved() || (objPlacement = placement.toJson()) == null) continue;
                arr.add((JsonElement)objPlacement);
                if (this.selectedPlacement == placement) {
                    indexValid = true;
                    continue;
                }
                if (indexValid) continue;
                ++selectedIndex;
            }
            obj.add("placements", (JsonElement)arr);
            if (indexValid) {
                obj.add("selected", (JsonElement)new JsonPrimitive((Number)selectedIndex));
                obj.add("origin_selected", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            }
        }
        return obj;
    }

    public void loadFromJson(JsonObject obj) {
        this.clear();
        if (JsonUtils.hasArray((JsonObject)obj, (String)"placements")) {
            JsonArray arr = obj.get("placements").getAsJsonArray();
            int index = JsonUtils.hasInteger((JsonObject)obj, (String)"selected") ? obj.get("selected").getAsInt() : -1;
            int size = arr.size();
            for (int i = 0; i < size; ++i) {
                JsonElement el = arr.get(i);
                if (el.isJsonObject()) {
                    SchematicPlacement placement = SchematicPlacement.fromJson(el.getAsJsonObject());
                    if (placement == null) continue;
                    this.addSchematicPlacement(placement, false);
                    continue;
                }
                index = -1;
            }
            if (index >= 0 && index < this.schematicPlacements.size()) {
                this.selectedPlacement = this.schematicPlacements.get(index);
            }
        }
        OverlayRenderer.getInstance().updatePlacementCache();
    }

    public static class PlacementPart {
        private final SchematicPlacement placement;
        private final String subRegionName;
        private final IntBoundingBox bb;

        public PlacementPart(SchematicPlacement placement, String subRegionName, IntBoundingBox bb) {
            this.placement = placement;
            this.subRegionName = subRegionName;
            this.bb = bb;
        }

        public SchematicPlacement getPlacement() {
            return this.placement;
        }

        public String getSubRegionName() {
            return this.subRegionName;
        }

        public IntBoundingBox getBox() {
            return this.bb;
        }
    }

    private static class PasteToCommandsListener
    implements IConfirmationListener {
        private final SchematicPlacement schematicPlacement;
        private final boolean changedBlocksOnly;

        public PasteToCommandsListener(SchematicPlacement schematicPlacement, boolean changedBlocksOnly) {
            this.schematicPlacement = schematicPlacement;
            this.changedBlocksOnly = changedBlocksOnly;
        }

        public boolean onActionConfirmed() {
            LayerRange range = DataManager.getRenderLayerRange();
            TaskPasteSchematicSetblockToMcfunction task = new TaskPasteSchematicSetblockToMcfunction(Collections.singletonList(this.schematicPlacement), range, this.changedBlocksOnly);
            TaskScheduler.getInstanceClient().scheduleTask(task, 1);
            return true;
        }

        public boolean onActionCancelled() {
            return true;
        }
    }
}

