/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.conversion;

import fi.dy.masa.litematica.schematic.conversion.IBlockReaderWithData;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionFixers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallStateFixer
implements SchematicConversionFixers.IStateFixer {
    public static final WallStateFixer INSTANCE = new WallStateFixer();
    private static final VoxelShape SHAPE_PILLAR = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    @Override
    public BlockState fixState(IBlockReaderWithData reader, BlockState state, BlockPos pos) {
        IBlockReaderWithData world = reader;
        FluidState fluidState = state.m_60819_();
        BlockPos posNorth = pos.m_142127_();
        BlockPos posEast = pos.m_142126_();
        BlockPos posSouth = pos.m_142128_();
        BlockPos posWest = pos.m_142125_();
        BlockPos posUp = pos.m_7494_();
        BlockState stateNorth = world.m_8055_(posNorth);
        BlockState stateEast = world.m_8055_(posEast);
        BlockState stateSouth = world.m_8055_(posSouth);
        BlockState stateWest = world.m_8055_(posWest);
        BlockState stateUp = world.m_8055_(posUp);
        boolean connectNorth = this.shouldConnectTo(stateNorth, stateNorth.m_60783_((BlockGetter)world, posNorth, Direction.SOUTH), Direction.SOUTH);
        boolean connectEast = this.shouldConnectTo(stateEast, stateEast.m_60783_((BlockGetter)world, posEast, Direction.WEST), Direction.WEST);
        boolean connectSouth = this.shouldConnectTo(stateSouth, stateSouth.m_60783_((BlockGetter)world, posSouth, Direction.NORTH), Direction.NORTH);
        boolean connectWest = this.shouldConnectTo(stateWest, stateWest.m_60783_((BlockGetter)world, posWest, Direction.EAST), Direction.EAST);
        BlockState baseState = (BlockState)state.m_60734_().m_49966_().m_61124_((Property)WallBlock.f_57954_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return this.getWallStateWithConnections(world, baseState, posUp, stateUp, connectNorth, connectEast, connectSouth, connectWest);
    }

    private BlockState getWallStateWithConnections(BlockGetter worldView, BlockState baseState, BlockPos pos, BlockState stateUp, boolean canConnectNorth, boolean canConnectEast, boolean canConnectSouth, boolean canConnectWest) {
        VoxelShape shapeAbove = stateUp.m_60812_(worldView, pos).m_83263_(Direction.DOWN);
        BlockState stateWithSides = this.getWallSideConnections(baseState, canConnectNorth, canConnectEast, canConnectSouth, canConnectWest, shapeAbove);
        return (BlockState)stateWithSides.m_61124_((Property)WallBlock.f_57949_, (Comparable)Boolean.valueOf(this.shouldConnectUp(stateWithSides, stateUp, shapeAbove)));
    }

    private BlockState getWallSideConnections(BlockState blockState, boolean canConnectNorth, boolean canConnectEast, boolean canConnectSouth, boolean canConnectWest, VoxelShape shapeAbove) {
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)WallBlock.f_57951_, (Comparable)this.getConnectionShape(canConnectNorth, shapeAbove, SHAPE_NORTH))).m_61124_((Property)WallBlock.f_57950_, (Comparable)this.getConnectionShape(canConnectEast, shapeAbove, SHAPE_EAST))).m_61124_((Property)WallBlock.f_57952_, (Comparable)this.getConnectionShape(canConnectSouth, shapeAbove, SHAPE_SOUTH))).m_61124_((Property)WallBlock.f_57953_, (Comparable)this.getConnectionShape(canConnectWest, shapeAbove, SHAPE_WEST));
    }

    private boolean shouldConnectTo(BlockState state, boolean faceFullSquare, Direction side) {
        Block block = state.m_60734_();
        return state.m_204336_(BlockTags.f_13032_) || !Block.m_152463_((BlockState)state) && faceFullSquare || block instanceof IronBarsBlock || block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)side);
    }

    private boolean shouldConnectUp(BlockState blockState, BlockState stateUp, VoxelShape shapeAbove) {
        boolean inTallLine;
        boolean isPillarOrWallEnd;
        boolean isUpConnectedWallAbove;
        boolean bl = isUpConnectedWallAbove = stateUp.m_60734_() instanceof WallBlock && (Boolean)stateUp.m_61143_((Property)WallBlock.f_57949_) != false;
        if (isUpConnectedWallAbove) {
            return true;
        }
        WallSide shapeNorth = (WallSide)blockState.m_61143_((Property)WallBlock.f_57951_);
        WallSide shapeSouth = (WallSide)blockState.m_61143_((Property)WallBlock.f_57952_);
        WallSide shapeEast = (WallSide)blockState.m_61143_((Property)WallBlock.f_57950_);
        WallSide shapeWest = (WallSide)blockState.m_61143_((Property)WallBlock.f_57953_);
        boolean unconnectedNorth = shapeNorth == WallSide.NONE;
        boolean unconnectedSouth = shapeSouth == WallSide.NONE;
        boolean unconnectedEast = shapeEast == WallSide.NONE;
        boolean unconnectedWest = shapeWest == WallSide.NONE;
        boolean bl2 = isPillarOrWallEnd = unconnectedNorth && unconnectedSouth && unconnectedWest && unconnectedEast || unconnectedNorth != unconnectedSouth || unconnectedWest != unconnectedEast;
        if (isPillarOrWallEnd) {
            return true;
        }
        boolean bl3 = inTallLine = shapeNorth == WallSide.TALL && shapeSouth == WallSide.TALL || shapeEast == WallSide.TALL && shapeWest == WallSide.TALL;
        if (inTallLine) {
            return false;
        }
        return stateUp.m_204336_(BlockTags.f_13081_) || this.shapesDoNotIntersect(shapeAbove, SHAPE_PILLAR);
    }

    private WallSide getConnectionShape(boolean canConnect, VoxelShape shapeAbove, VoxelShape shapeSideClearance) {
        if (canConnect) {
            return this.shapesDoNotIntersect(shapeAbove, shapeSideClearance) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    private boolean shapesDoNotIntersect(VoxelShape voxelShape, VoxelShape voxelShape2) {
        return !Shapes.m_83157_((VoxelShape)voxelShape2, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.f_82685_);
    }
}

