/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.conversion;

import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.conversion.IBlockReaderWithData;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionFixers;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionMaps;
import fi.dy.masa.litematica.schematic.conversion.WallStateFixer;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class SchematicConverter {
    private final IdentityHashMap<Class<? extends Block>, SchematicConversionFixers.IStateFixer> fixersPerBlock = new IdentityHashMap();
    private IdentityHashMap<BlockState, SchematicConversionFixers.IStateFixer> postProcessingStateFixers = new IdentityHashMap();

    private SchematicConverter() {
    }

    public static SchematicConverter createForSchematica() {
        SchematicConverter converter = new SchematicConverter();
        converter.addPostUpdateBlocksSchematica();
        return converter;
    }

    public static SchematicConverter createForLitematica() {
        SchematicConverter converter = new SchematicConverter();
        converter.addPostUpdateBlocksLitematica();
        return converter;
    }

    public boolean getConvertedStatesForBlock(int schematicBlockId, String blockName, BlockState[] paletteOut) {
        int shiftedOldVanillaId = SchematicConversionMaps.getOldNameToShiftedBlockId(blockName);
        int successCount = 0;
        if (shiftedOldVanillaId >= 0) {
            for (int meta = 0; meta < 16; ++meta) {
                BlockState state = SchematicConversionMaps.get_1_13_2_StateForIdMeta(shiftedOldVanillaId & 0xFFF0 | meta);
                if (state == null) continue;
                paletteOut[schematicBlockId << 4 | meta] = state;
                ++successCount;
            }
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to convert block with old name '" + blockName + "'"), (Object[])new Object[0]);
        }
        return successCount > 0;
    }

    public boolean getVanillaBlockPalette(BlockState[] paletteOut) {
        for (int idMeta = 0; idMeta < paletteOut.length; ++idMeta) {
            BlockState state = SchematicConversionMaps.get_1_13_2_StateForIdMeta(idMeta);
            if (state == null) continue;
            paletteOut[idMeta] = state;
        }
        return true;
    }

    public BlockState[] getBlockStatePaletteForBlockPalette(String[] blockPalette) {
        Object[] palette = new BlockState[blockPalette.length * 16];
        Arrays.fill(palette, Blocks.f_50016_.m_49966_());
        for (int schematicBlockId = 0; schematicBlockId < blockPalette.length; ++schematicBlockId) {
            String blockName = blockPalette[schematicBlockId];
            this.getConvertedStatesForBlock(schematicBlockId, blockName, (BlockState[])palette);
        }
        return palette;
    }

    public boolean createPostProcessStateFilter(BlockState[] palette) {
        return this.createPostProcessStateFilter(Arrays.asList(palette));
    }

    public boolean createPostProcessStateFilter(Collection<BlockState> palette) {
        boolean needsPostProcess = false;
        this.postProcessingStateFixers.clear();
        for (BlockState state : palette) {
            if (!this.needsPostProcess(state)) continue;
            this.postProcessingStateFixers.put(state, this.getFixerFor(state));
            needsPostProcess = true;
        }
        return needsPostProcess;
    }

    public IdentityHashMap<BlockState, SchematicConversionFixers.IStateFixer> getPostProcessStateFilter() {
        return this.postProcessingStateFixers;
    }

    private boolean needsPostProcess(BlockState state) {
        return !state.m_60795_() && this.fixersPerBlock.containsKey(state.m_60734_().getClass());
    }

    @Nullable
    private SchematicConversionFixers.IStateFixer getFixerFor(BlockState state) {
        return this.fixersPerBlock.get(state.m_60734_().getClass());
    }

    public CompoundTag fixTileEntityNBT(CompoundTag tag, BlockState state) {
        return tag;
    }

    public static void postProcessBlocks(LitematicaBlockStateContainer container, @Nullable Map<BlockPos, CompoundTag> tiles, IdentityHashMap<BlockState, SchematicConversionFixers.IStateFixer> postProcessingFilter) {
        int sizeX = container.getSize().m_123341_();
        int sizeY = container.getSize().m_123342_();
        int sizeZ = container.getSize().m_123343_();
        BlockReaderLitematicaContainer reader = new BlockReaderLitematicaContainer(container, tiles);
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (int y = 0; y < sizeY; ++y) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int x = 0; x < sizeX; ++x) {
                    BlockState state = container.get(x, y, z);
                    SchematicConversionFixers.IStateFixer fixer = postProcessingFilter.get(state);
                    if (fixer == null) continue;
                    posMutable.m_122178_(x, y, z);
                    BlockState stateFixed = fixer.fixState(reader, state, (BlockPos)posMutable);
                    if (stateFixed == state) continue;
                    container.set(x, y, z, stateFixed);
                }
            }
        }
    }

    private void addPostUpdateBlocksLitematica() {
        this.fixersPerBlock.put(RedStoneWireBlock.class, SchematicConversionFixers.FIXER_REDSTONE_WIRE);
        this.fixersPerBlock.put(WallBlock.class, WallStateFixer.INSTANCE);
        this.fixersPerBlock.put(BannerBlock.class, SchematicConversionFixers.FIXER_BANNER);
        this.fixersPerBlock.put(WallBannerBlock.class, SchematicConversionFixers.FIXER_BANNER_WALL);
        this.fixersPerBlock.put(BedBlock.class, SchematicConversionFixers.FIXER_BED);
        this.fixersPerBlock.put(FlowerPotBlock.class, SchematicConversionFixers.FIXER_FLOWER_POT);
        this.fixersPerBlock.put(NoteBlock.class, SchematicConversionFixers.FIXER_NOTE_BLOCK);
        this.fixersPerBlock.put(SkullBlock.class, SchematicConversionFixers.FIXER_SKULL);
        this.fixersPerBlock.put(WallSkullBlock.class, SchematicConversionFixers.FIXER_SKULL_WALL);
    }

    private void addPostUpdateBlocksSchematica() {
        this.fixersPerBlock.put(ChorusPlantBlock.class, SchematicConversionFixers.FIXER_CHRORUS_PLANT);
        this.fixersPerBlock.put(DoorBlock.class, SchematicConversionFixers.FIXER_DOOR);
        this.fixersPerBlock.put(FenceBlock.class, SchematicConversionFixers.FIXER_FENCE);
        this.fixersPerBlock.put(FenceGateBlock.class, SchematicConversionFixers.FIXER_FENCE_GATE);
        this.fixersPerBlock.put(FireBlock.class, SchematicConversionFixers.FIXER_FIRE);
        this.fixersPerBlock.put(GrassBlock.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(MyceliumBlock.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(IronBarsBlock.class, SchematicConversionFixers.FIXER_PANE);
        this.fixersPerBlock.put(RepeaterBlock.class, SchematicConversionFixers.FIXER_REDSTONE_REPEATER);
        this.fixersPerBlock.put(RedStoneWireBlock.class, SchematicConversionFixers.FIXER_REDSTONE_WIRE);
        this.fixersPerBlock.put(SnowyDirtBlock.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(StemBlock.class, SchematicConversionFixers.FIXER_STEM);
        this.fixersPerBlock.put(StainedGlassPaneBlock.class, SchematicConversionFixers.FIXER_PANE);
        this.fixersPerBlock.put(StairBlock.class, SchematicConversionFixers.FIXER_STAIRS);
        this.fixersPerBlock.put(TallFlowerBlock.class, SchematicConversionFixers.FIXER_DOUBLE_PLANT);
        this.fixersPerBlock.put(DoublePlantBlock.class, SchematicConversionFixers.FIXER_DOUBLE_PLANT);
        this.fixersPerBlock.put(TripWireBlock.class, SchematicConversionFixers.FIXER_TRIPWIRE);
        this.fixersPerBlock.put(VineBlock.class, SchematicConversionFixers.FIXER_VINE);
        this.fixersPerBlock.put(WallBlock.class, WallStateFixer.INSTANCE);
        this.fixersPerBlock.put(BannerBlock.class, SchematicConversionFixers.FIXER_BANNER);
        this.fixersPerBlock.put(WallBannerBlock.class, SchematicConversionFixers.FIXER_BANNER_WALL);
        this.fixersPerBlock.put(BedBlock.class, SchematicConversionFixers.FIXER_BED);
        this.fixersPerBlock.put(FlowerPotBlock.class, SchematicConversionFixers.FIXER_FLOWER_POT);
        this.fixersPerBlock.put(NoteBlock.class, SchematicConversionFixers.FIXER_NOTE_BLOCK);
        this.fixersPerBlock.put(SkullBlock.class, SchematicConversionFixers.FIXER_SKULL);
        this.fixersPerBlock.put(WallSkullBlock.class, SchematicConversionFixers.FIXER_SKULL_WALL);
    }

    public static class BlockReaderLitematicaContainer
    implements IBlockReaderWithData {
        private final LitematicaBlockStateContainer container;
        private final Map<BlockPos, CompoundTag> blockEntityData;
        private final Vec3i size;
        private final BlockState air;

        public BlockReaderLitematicaContainer(LitematicaBlockStateContainer container, @Nullable Map<BlockPos, CompoundTag> blockEntityData) {
            this.container = container;
            this.blockEntityData = blockEntityData != null ? blockEntityData : new HashMap();
            this.size = container.getSize();
            this.air = Blocks.f_50016_.m_49966_();
        }

        public BlockState m_8055_(BlockPos pos) {
            if (pos.m_123341_() >= 0 && pos.m_123341_() < this.size.m_123341_() && pos.m_123342_() >= 0 && pos.m_123342_() < this.size.m_123342_() && pos.m_123343_() >= 0 && pos.m_123343_() < this.size.m_123343_()) {
                return this.container.get(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            }
            return this.air;
        }

        public FluidState m_6425_(BlockPos pos) {
            return this.m_8055_(pos).m_60819_();
        }

        @Nullable
        public BlockEntity m_7702_(BlockPos pos) {
            return null;
        }

        @Override
        @Nullable
        public CompoundTag getBlockEntityData(BlockPos pos) {
            return this.blockEntityData.get(pos);
        }
    }
}

