/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionFixers;
import fi.dy.masa.litematica.schematic.conversion.SchematicConverter;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.NbtUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.NBTUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SchematicaSchematic {
    public static final String FILE_EXTENSION = ".schematic";
    private final SchematicConverter converter;
    private final BlockState[] palette = new BlockState[65536];
    private LitematicaBlockStateContainer blocks;
    private Map<BlockPos, CompoundTag> tiles = new HashMap<BlockPos, CompoundTag>();
    private List<CompoundTag> entities = new ArrayList<CompoundTag>();
    private Vec3i size = Vec3i.f_123288_;
    private String fileName;
    private IdentityHashMap<BlockState, SchematicConversionFixers.IStateFixer> postProcessingFilter;
    private boolean needsConversionPostProcessing;

    private SchematicaSchematic() {
        this.converter = SchematicConverter.createForSchematica();
    }

    public Vec3i getSize() {
        return this.size;
    }

    public Map<BlockPos, CompoundTag> getTiles() {
        return this.tiles;
    }

    public List<LitematicaSchematic.EntityInfo> getEntities() {
        ArrayList<LitematicaSchematic.EntityInfo> entityList = new ArrayList<LitematicaSchematic.EntityInfo>();
        int size = this.entities.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag entityData = this.entities.get(i);
            Vec3 posVec = NBTUtils.readEntityPositionFromTag((CompoundTag)entityData);
            if (posVec == null || entityData.m_128456_()) continue;
            entityList.add(new LitematicaSchematic.EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    public void placeSchematicToWorld(Level world, BlockPos posStart, StructurePlaceSettings placement, int setBlockStateFlags) {
        int width = this.size.m_123341_();
        int height = this.size.m_123342_();
        int length = this.size.m_123343_();
        int numBlocks = width * height * length;
        if (this.blocks != null && numBlocks > 0 && this.blocks.getSize().equals((Object)this.size)) {
            int x;
            int z;
            int y;
            Rotation rotation = placement.m_74404_();
            Mirror mirror = placement.m_74401_();
            for (y = 0; y < height; ++y) {
                for (z = 0; z < length; ++z) {
                    for (x = 0; x < width; ++x) {
                        BlockEntity te;
                        BlockState state = this.blocks.get(x, y, z);
                        BlockPos pos = new BlockPos(x, y, z);
                        CompoundTag teNBT = this.tiles.get(pos);
                        pos = StructureTemplate.m_74563_((StructurePlaceSettings)placement, (BlockPos)pos).m_141952_((Vec3i)posStart);
                        state = state.m_60715_(mirror);
                        state = state.m_60717_(rotation);
                        if (teNBT != null && (te = world.m_7702_(pos)) != null) {
                            if (te instanceof Container) {
                                ((Container)te).m_6211_();
                            }
                            world.m_7731_(pos, Blocks.f_50375_.m_49966_(), 20);
                        }
                        if (!world.m_7731_(pos, state, setBlockStateFlags) || teNBT == null || (te = world.m_7702_(pos)) == null) continue;
                        teNBT.m_128405_("x", pos.m_123341_());
                        teNBT.m_128405_("y", pos.m_123342_());
                        teNBT.m_128405_("z", pos.m_123343_());
                        try {
                            te.m_142466_(teNBT);
                            continue;
                        }
                        catch (Exception e) {
                            Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                        }
                    }
                }
            }
            if ((setBlockStateFlags & 1) != 0) {
                for (y = 0; y < height; ++y) {
                    for (z = 0; z < length; ++z) {
                        for (x = 0; x < width; ++x) {
                            BlockEntity te;
                            BlockPos pos = new BlockPos(x, y, z);
                            CompoundTag teNBT = this.tiles.get(pos);
                            pos = StructureTemplate.m_74563_((StructurePlaceSettings)placement, (BlockPos)pos).m_141952_((Vec3i)posStart);
                            world.m_6289_(pos, world.m_8055_(pos).m_60734_());
                            if (teNBT == null || (te = world.m_7702_(pos)) == null) continue;
                            te.m_6596_();
                        }
                    }
                }
            }
            if (!placement.m_74408_()) {
                this.addEntitiesToWorld(world, posStart, placement);
            }
        }
    }

    public void placeSchematicDirectlyToChunks(Level world, BlockPos posStart, StructurePlaceSettings placement) {
        int width = this.size.m_123341_();
        int height = this.size.m_123342_();
        int length = this.size.m_123343_();
        int numBlocks = width * height * length;
        BlockPos posEnd = posStart.m_141952_(this.size).m_142082_(-1, -1, -1);
        if (this.blocks != null && numBlocks > 0 && this.blocks.getSize().equals((Object)this.size) && PositionUtils.arePositionsWithinWorld(world, posStart, posEnd)) {
            BlockPos posMin = PositionUtils.getMinCorner(posStart, posEnd);
            BlockPos posMax = PositionUtils.getMaxCorner(posStart, posEnd);
            int cxStart = posMin.m_123341_() >> 4;
            int czStart = posMin.m_123343_() >> 4;
            int cxEnd = posMax.m_123341_() >> 4;
            int czEnd = posMax.m_123343_() >> 4;
            BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
            for (int cz = czStart; cz <= czEnd; ++cz) {
                for (int cx = cxStart; cx <= cxEnd; ++cx) {
                    int xMinChunk = Math.max(cx << 4, posMin.m_123341_());
                    int zMinChunk = Math.max(cz << 4, posMin.m_123343_());
                    int xMaxChunk = Math.min((cx << 4) + 15, posMax.m_123341_());
                    int zMaxChunk = Math.min((cz << 4) + 15, posMax.m_123343_());
                    LevelChunk chunk = world.m_6325_(cx, cz);
                    if (chunk == null) continue;
                    int y = posMin.m_123342_();
                    for (int ySrc = 0; ySrc < height; ++ySrc) {
                        int z = zMinChunk;
                        int zSrc = zMinChunk - posStart.m_123343_();
                        while (z <= zMaxChunk) {
                            int x = xMinChunk;
                            int xSrc = xMinChunk - posStart.m_123341_();
                            while (x <= xMaxChunk) {
                                BlockEntity te;
                                BlockState state = this.blocks.get(xSrc, ySrc, zSrc);
                                posMutable.m_122178_(xSrc, ySrc, zSrc);
                                CompoundTag teNBT = this.tiles.get(posMutable);
                                BlockPos pos = new BlockPos(x, y, z);
                                if (teNBT != null && (te = chunk.m_5685_(pos, LevelChunk.EntityCreationType.CHECK)) != null) {
                                    if (te instanceof Container) {
                                        ((Container)te).m_6211_();
                                    }
                                    world.m_7731_(pos, Blocks.f_50375_.m_49966_(), 20);
                                }
                                chunk.m_6978_(pos, state, false);
                                if (teNBT != null && (te = chunk.m_5685_(pos, LevelChunk.EntityCreationType.CHECK)) != null) {
                                    teNBT.m_128405_("x", pos.m_123341_());
                                    teNBT.m_128405_("y", pos.m_123342_());
                                    teNBT.m_128405_("z", pos.m_123343_());
                                    try {
                                        te.m_142466_(teNBT);
                                    }
                                    catch (Exception e) {
                                        Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                                    }
                                }
                                ++x;
                                ++xSrc;
                            }
                            ++z;
                            ++zSrc;
                        }
                        ++y;
                    }
                }
            }
            if (!placement.m_74408_()) {
                this.addEntitiesToWorld(world, posStart, placement);
            }
        }
    }

    private void addEntitiesToWorld(Level world, BlockPos posStart, StructurePlaceSettings placement) {
        Mirror mirror = placement.m_74401_();
        Rotation rotation = placement.m_74404_();
        for (CompoundTag tag : this.entities) {
            Vec3 relativePos = NBTUtils.readEntityPositionFromTag((CompoundTag)tag);
            Vec3 transformedRelativePos = PositionUtils.getTransformedPosition(relativePos, mirror, rotation);
            Vec3 realPos = transformedRelativePos.m_82520_((double)posStart.m_123341_(), (double)posStart.m_123342_(), (double)posStart.m_123343_());
            Entity entity = EntityUtils.createEntityAndPassengersFromNBT(tag, world);
            if (entity == null) continue;
            float rotationYaw = entity.m_6961_(mirror);
            entity.m_7678_(realPos.f_82479_, realPos.f_82480_, realPos.f_82481_, rotationYaw += entity.m_146908_() - entity.m_7890_(rotation), entity.m_146909_());
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    public Map<BlockPos, String> getDataStructureBlocks(BlockPos posStart, StructurePlaceSettings placement) {
        HashMap<BlockPos, String> map = new HashMap<BlockPos, String>();
        for (Map.Entry<BlockPos, CompoundTag> entry : this.tiles.entrySet()) {
            CompoundTag tag = entry.getValue();
            if (!tag.m_128461_("id").equals("minecraft:structure_block") || StructureMode.valueOf((String)tag.m_128461_("mode")) != StructureMode.DATA) continue;
            BlockPos pos = entry.getKey();
            pos = StructureTemplate.m_74563_((StructurePlaceSettings)placement, (BlockPos)pos).m_141952_((Vec3i)posStart);
            map.put(pos, tag.m_128461_("metadata"));
        }
        return map;
    }

    private void readBlocksFromWorld(Level world, BlockPos posStart, BlockPos size) {
        int startX = posStart.m_123341_();
        int startY = posStart.m_123342_();
        int startZ = posStart.m_123343_();
        int endX = startX + size.m_123341_();
        int endY = startY + size.m_123342_();
        int endZ = startZ + size.m_123343_();
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos(0, 0, 0);
        this.blocks = new LitematicaBlockStateContainer(size.m_123341_(), size.m_123342_(), size.m_123343_());
        this.tiles.clear();
        this.size = size;
        for (int y = startY; y < endY; ++y) {
            for (int z = startZ; z < endZ; ++z) {
                for (int x = startX; x < endX; ++x) {
                    int relX = x - startX;
                    int relY = y - startY;
                    int relZ = z - startZ;
                    posMutable.m_122178_(x, y, z);
                    BlockState state = world.m_8055_((BlockPos)posMutable);
                    this.blocks.set(relX, relY, relZ, state);
                    BlockEntity te = world.m_7702_((BlockPos)posMutable);
                    if (te == null) continue;
                    try {
                        CompoundTag nbt = te.m_187482_();
                        nbt.m_128405_("x", relX);
                        nbt.m_128405_("y", relY);
                        nbt.m_128405_("z", relZ);
                        this.tiles.put(new BlockPos(relX, relY, relZ), nbt);
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("SchematicaSchematic: Exception while trying to store TileEntity data for block '{}' at {}", (Object)state, (Object)posMutable.toString(), (Object)e);
                    }
                }
            }
        }
    }

    private void readEntitiesFromWorld(Level world, BlockPos posStart, BlockPos size) {
        this.entities.clear();
        List entities = world.m_6249_(null, new AABB(posStart, posStart.m_141952_((Vec3i)size)), e -> !(e instanceof Player));
        for (Entity entity : entities) {
            CompoundTag tag;
            if (!entity.m_20223_(tag = new CompoundTag())) continue;
            Vec3 pos = new Vec3(entity.m_20185_() - (double)posStart.m_123341_(), entity.m_20186_() - (double)posStart.m_123342_(), entity.m_20189_() - (double)posStart.m_123343_());
            NBTUtils.writeEntityPositionToTag((Vec3)pos, (CompoundTag)tag);
            this.entities.add(tag);
        }
    }

    public static SchematicaSchematic createFromWorld(Level world, BlockPos posStart, BlockPos size, boolean ignoreEntities) {
        SchematicaSchematic schematic = new SchematicaSchematic();
        schematic.readBlocksFromWorld(world, posStart, size);
        if (!ignoreEntities) {
            schematic.readEntitiesFromWorld(world, posStart, size);
        }
        return schematic;
    }

    @Nullable
    public static SchematicaSchematic createFromFile(File file) {
        SchematicaSchematic schematic = new SchematicaSchematic();
        if (schematic.readFromFile(file)) {
            return schematic;
        }
        return null;
    }

    public boolean readFromNBT(CompoundTag nbt) {
        if (this.readBlocksFromNBT(nbt)) {
            this.readEntitiesFromNBT(nbt);
            this.readTileEntitiesFromNBT(nbt);
            try {
                this.postProcessBlocks();
            }
            catch (Exception e) {
                Litematica.logger.error("SchematicaSchematic: Exception while post-processing blocks for '{}'", (Object)this.fileName, (Object)e);
            }
            return true;
        }
        Litematica.logger.error("SchematicaSchematic: Missing block data in the schematic '{}'", (Object)this.fileName);
        return false;
    }

    private boolean readPaletteFromNBT(CompoundTag nbt) {
        Arrays.fill(this.palette, Blocks.f_50016_.m_49966_());
        if (nbt.m_128425_("SchematicaMapping", 10)) {
            CompoundTag tag = nbt.m_128469_("SchematicaMapping");
            Set keys = tag.m_128431_();
            for (String key : keys) {
                String str;
                short id = tag.m_128448_(key);
                if (id < 0 || id >= 4096) {
                    str = String.format("SchematicaSchematic: Invalid ID '%d' in SchematicaMapping for block '%s', range: 0 - 4095", id, key);
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                    Litematica.logger.warn(str);
                    return false;
                }
                if (this.converter.getConvertedStatesForBlock(id, key, this.palette)) continue;
                str = String.format("SchematicaSchematic: Missing/non-existing block '%s' in SchematicaMapping", key);
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                Litematica.logger.warn(str);
            }
        } else if (nbt.m_128425_("BlockIDs", 10)) {
            CompoundTag tag = nbt.m_128469_("BlockIDs");
            Set keys = tag.m_128431_();
            for (String idStr : keys) {
                String str;
                int id;
                String key = tag.m_128461_(idStr);
                try {
                    id = Integer.parseInt(idStr);
                }
                catch (NumberFormatException e) {
                    String str2 = String.format("SchematicaSchematic: Invalid ID '%d' (not a number) in MCEdit2 palette for block '%s'", idStr, key);
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str2, (Object[])new Object[0]);
                    Litematica.logger.warn(str2);
                    return false;
                }
                if (id < 0 || id >= 4096) {
                    str = String.format("SchematicaSchematic: Invalid ID '%d' in MCEdit2 palette for block '%s', range: 0 - 4095", id, key);
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                    Litematica.logger.warn(str);
                    return false;
                }
                if (this.converter.getConvertedStatesForBlock(id, key, this.palette)) continue;
                str = String.format("SchematicaSchematic: Missing/non-existing block '%s' in MCEdit2 palette", key);
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                Litematica.logger.warn(str);
            }
        } else {
            this.converter.getVanillaBlockPalette(this.palette);
        }
        if (this.converter.createPostProcessStateFilter(this.palette)) {
            this.postProcessingFilter = this.converter.getPostProcessStateFilter();
            this.needsConversionPostProcessing = true;
        }
        return true;
    }

    private boolean readBlocksFromNBT(CompoundTag nbt) {
        int z;
        int y;
        int x;
        BlockState state;
        byte addValue;
        int expectedAddLength;
        if (!(nbt.m_128425_("Blocks", 7) && nbt.m_128425_("Data", 7) && nbt.m_128425_("Width", 2) && nbt.m_128425_("Height", 2) && nbt.m_128425_("Length", 2))) {
            return false;
        }
        short sizeX = nbt.m_128448_("Width");
        short sizeY = nbt.m_128448_("Height");
        short sizeZ = nbt.m_128448_("Length");
        byte[] blockIdsByte = nbt.m_128463_("Blocks");
        byte[] metaArr = nbt.m_128463_("Data");
        int numBlocks = blockIdsByte.length;
        int layerSize = sizeX * sizeZ;
        if (numBlocks != sizeX * sizeY * sizeZ) {
            String str = String.format("SchematicaSchematic: Mismatched block array size compared to the width/height/length,\nblocks: %d, W x H x L: %d x %d x %d", numBlocks, (int)sizeX, (int)sizeY, (int)sizeZ);
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
            return false;
        }
        if (numBlocks != metaArr.length) {
            String str = String.format("SchematicaSchematic: Mismatched block ID and metadata array sizes, blocks: %d, meta: %d", numBlocks, metaArr.length);
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
            return false;
        }
        if (!this.readPaletteFromNBT(nbt)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"SchematicaSchematic: Failed to read the block palette", (Object[])new Object[0]);
            return false;
        }
        this.size = new Vec3i((int)sizeX, (int)sizeY, (int)sizeZ);
        this.blocks = new LitematicaBlockStateContainer(sizeX, (int)sizeY, sizeZ);
        if (nbt.m_128425_("Add", 7)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"SchematicaSchematic: Old Schematica format detected, not currently implemented...", (Object[])new Object[0]);
            return false;
        }
        byte[] add = null;
        if (nbt.m_128425_("AddBlocks", 7) && (add = nbt.m_128463_("AddBlocks")).length != (expectedAddLength = (int)Math.ceil((double)blockIdsByte.length / 2.0))) {
            String str = String.format("SchematicaSchematic: Add array size mismatch, blocks: %d, add: %d, expected add: %d", numBlocks, add.length, expectedAddLength);
            if (add.length < expectedAddLength) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                return false;
            }
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)str, (Object[])new Object[0]);
        }
        int loopMax = numBlocks % 2 == 0 ? numBlocks - 1 : numBlocks - 2;
        int bi = 0;
        int ai = 0;
        while (bi < loopMax) {
            addValue = add != null ? add[ai] : (byte)0;
            int byteId = blockIdsByte[bi] & 0xFF;
            state = this.palette[(addValue & 0xF0) << 8 | byteId << 4 | metaArr[bi]];
            x = bi % sizeX;
            y = bi / layerSize;
            z = bi % layerSize / sizeX;
            this.blocks.set(x, y, z, state);
            x = (bi + 1) % sizeX;
            y = (bi + 1) / layerSize;
            z = (bi + 1) % layerSize / sizeX;
            byteId = blockIdsByte[bi + 1] & 0xFF;
            state = this.palette[(addValue & 0xF) << 12 | byteId << 4 | metaArr[bi + 1]];
            this.blocks.set(x, y, z, state);
            bi += 2;
            ++ai;
        }
        if (numBlocks % 2 != 0) {
            addValue = add != null ? add[ai] : (byte)0;
            int byteId = blockIdsByte[bi] & 0xFF;
            state = this.palette[(addValue & 0xF0) << 8 | byteId << 4 | metaArr[bi]];
            x = bi % sizeX;
            y = bi / layerSize;
            z = bi % layerSize / sizeX;
            this.blocks.set(x, y, z, state);
        }
        return true;
    }

    private void postProcessBlocks() {
        if (this.needsConversionPostProcessing) {
            SchematicConverter.postProcessBlocks(this.blocks, this.tiles, this.postProcessingFilter);
        }
    }

    private void readEntitiesFromNBT(CompoundTag nbt) {
        this.entities.clear();
        ListTag tagList = nbt.m_128437_("Entities", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            this.entities.add(tagList.m_128728_(i));
        }
    }

    private void readTileEntitiesFromNBT(CompoundTag nbt) {
        this.tiles.clear();
        ListTag tagList = nbt.m_128437_("TileEntities", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tag = tagList.m_128728_(i);
            BlockPos pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
            Vec3i size = this.blocks.getSize();
            if (pos.m_123341_() < 0 || pos.m_123341_() >= size.m_123341_() || pos.m_123342_() < 0 || pos.m_123342_() >= size.m_123342_() || pos.m_123343_() < 0 || pos.m_123343_() >= size.m_123343_()) continue;
            tag = this.converter.fixTileEntityNBT(tag, this.blocks.get(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
            this.tiles.put(pos, tag);
        }
    }

    public boolean readFromFile(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            this.fileName = file.getName();
            try {
                CompoundTag nbt = NbtUtils.readNbtFromFile(file);
                return this.readFromNBT(nbt);
            }
            catch (Exception e) {
                Litematica.logger.error("SchematicaSchematic: Failed to read Schematic data from file '{}'", (Object)file.getAbsolutePath());
            }
        }
        return false;
    }
}

