/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.scheduler.tasks.TaskProcessChunkBase;
import fi.dy.masa.litematica.util.ToBooleanFunction;
import fi.dy.masa.malilib.util.IntBoundingBox;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;

public abstract class TaskProcessChunkMultiPhase
extends TaskProcessChunkBase {
    protected TaskPhase phase = TaskPhase.INIT;
    @Nullable
    protected ChunkPos currentChunkPos;
    @Nullable
    protected IntBoundingBox currentBox;
    @Nullable
    protected Iterator<Entity> entityIterator;
    @Nullable
    protected Iterator<BlockPos> positionIterator;
    protected int maxCommandsPerTick = 16;
    protected int processedChunksThisTick;
    protected int sentCommandsThisTick;
    protected long gameRuleProbeTimeout;
    protected long maxGameRuleProbeTime = 2000000000L;
    protected long taskStartTimeForCurrentTick;
    protected boolean shouldEnableFeedback;
    protected ToBooleanFunction<Component> gameRuleListener = this::checkCommandFeedbackGameRuleState;
    protected Runnable initTask = this::initPhaseStartProbe;
    protected Runnable probeTask = this::probePhase;
    protected Runnable waitForChunkTask = this::fetchNextChunk;
    protected Runnable processBoxBlocksTask;
    protected Runnable processBoxEntitiesTask;

    protected TaskProcessChunkMultiPhase(String nameOnHud) {
        super(nameOnHud);
    }

    protected boolean executeMultiPhase() {
        long currentTime;
        long elapsedTickTime;
        this.taskStartTimeForCurrentTick = Util.m_137569_();
        this.sentCommandsThisTick = 0;
        this.processedChunksThisTick = 0;
        if (this.phase == TaskPhase.INIT) {
            this.initTask.run();
        }
        if (this.phase == TaskPhase.GAME_RULE_PROBE) {
            this.probeTask.run();
            return false;
        }
        if (this.currentChunkPos != null && !this.canProcessChunk(this.currentChunkPos)) {
            return false;
        }
        int commandsLast = -1;
        ChunkPos lastChunk = this.currentChunkPos;
        while (!(this.sentCommandsThisTick >= this.maxCommandsPerTick || this.sentCommandsThisTick <= commandsLast && Objects.equals(lastChunk, this.currentChunkPos) || (elapsedTickTime = (currentTime = Util.m_137569_()) - this.taskStartTimeForCurrentTick) >= 25000000L)) {
            commandsLast = this.sentCommandsThisTick;
            lastChunk = this.currentChunkPos;
            if (this.phase == TaskPhase.WAIT_FOR_CHUNKS) {
                this.waitForChunkTask.run();
            }
            if (this.phase == TaskPhase.PROCESS_BOX_BLOCKS) {
                this.processBoxBlocksTask.run();
            }
            if (this.phase == TaskPhase.PROCESS_BOX_ENTITIES) {
                this.processBoxEntitiesTask.run();
            }
            if (this.phase != TaskPhase.FINISHED) continue;
            return true;
        }
        if (this.processedChunksThisTick > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    protected void initPhaseStartProbe() {
        if (Configs.Generic.COMMAND_DISABLE_FEEDBACK.getBooleanValue()) {
            DataManager.addChatListener(this.gameRuleListener);
            this.mc.f_91074_.m_108739_("/gamerule sendCommandFeedback");
            this.gameRuleProbeTimeout = Util.m_137569_() + this.maxGameRuleProbeTime;
            this.phase = TaskPhase.GAME_RULE_PROBE;
        } else {
            this.shouldEnableFeedback = false;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        }
    }

    protected void probePhase() {
        if (Util.m_137569_() > this.gameRuleProbeTimeout) {
            this.shouldEnableFeedback = false;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        }
    }

    protected boolean checkCommandFeedbackGameRuleState(Component message) {
        TranslatableComponent translatableText;
        if (message instanceof TranslatableComponent && "commands.gamerule.query".equals((translatableText = (TranslatableComponent)message).m_131328_())) {
            this.shouldEnableFeedback = translatableText.getString().contains("true");
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
            if (this.shouldEnableFeedback) {
                this.mc.f_91074_.m_108739_("/gamerule sendCommandFeedback false");
            }
            return true;
        }
        return false;
    }

    protected void fetchNextChunk() {
        if (!this.pendingChunks.isEmpty()) {
            this.sortChunkList();
            ChunkPos pos = (ChunkPos)this.pendingChunks.get(0);
            if (this.canProcessChunk(pos)) {
                this.currentChunkPos = pos;
                this.onNextChunkFetched(pos);
            }
        } else {
            this.phase = TaskPhase.FINISHED;
            this.finished = true;
        }
    }

    protected void onNextChunkFetched(ChunkPos pos) {
    }

    protected void startNextBox(ChunkPos pos) {
        List list = this.boxesInChunks.get((Object)pos);
        if (!list.isEmpty()) {
            this.currentBox = (IntBoundingBox)list.get(0);
            this.onStartNextBox(this.currentBox);
        } else {
            this.currentBox = null;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        }
    }

    protected void onStartNextBox(IntBoundingBox box) {
    }

    protected void onFinishedProcessingBox(ChunkPos pos, IntBoundingBox box) {
        this.boxesInChunks.remove((Object)pos, (Object)box);
        this.currentBox = null;
        this.entityIterator = null;
        this.positionIterator = null;
        if (this.boxesInChunks.get((Object)pos).isEmpty()) {
            this.finishProcessingChunk(pos);
        } else {
            this.startNextBox(pos);
        }
    }

    protected void finishProcessingChunk(ChunkPos pos) {
        this.boxesInChunks.removeAll((Object)pos);
        this.pendingChunks.remove(pos);
        this.currentChunkPos = null;
        ++this.processedChunksThisTick;
        this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        this.onFinishedProcessingChunk(pos);
    }

    protected void onFinishedProcessingChunk(ChunkPos pos) {
    }

    protected void sendCommand(String command, LocalPlayer player) {
        this.sendCommandToServer(command, player);
        ++this.sentCommandsThisTick;
    }

    protected void sendCommandToServer(String command, LocalPlayer player) {
        if (command.length() > 0 && command.charAt(0) != '/') {
            player.m_108739_("/" + command);
        } else {
            player.m_108739_(command);
        }
    }

    public static enum TaskPhase {
        INIT,
        GAME_RULE_PROBE,
        WAIT_FOR_CHUNKS,
        PROCESS_BOX_BLOCKS,
        PROCESS_BOX_ENTITIES,
        FINISHED;

    }
}

