/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.mixin;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.mixin.IMixinChunkDeltaUpdateS2CPacket;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientboundChatPacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinClientPlayNetworkHandler {
    @Inject(method={"onChunkData"}, at={@At(value="RETURN")})
    private void onChunkData(ClientboundLevelChunkWithLightPacket packetIn, CallbackInfo ci) {
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            SchematicWorldRefresher.INSTANCE.markSchematicChunksForRenderUpdate(packetIn.m_195717_(), packetIn.m_195718_());
        }
        DataManager.getSchematicPlacementManager().onClientChunkLoad(packetIn.m_195717_(), packetIn.m_195718_());
    }

    @Inject(method={"onChunkDeltaUpdate"}, at={@At(value="RETURN")})
    private void onChunkDelta(ClientboundSectionBlocksUpdatePacket packet, CallbackInfo ci) {
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            SectionPos pos = ((IMixinChunkDeltaUpdateS2CPacket)packet).litematica_getSection();
            SchematicWorldRefresher.INSTANCE.markSchematicChunksForRenderUpdate(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            packet.m_132992_((p, s) -> SchematicVerifier.markVerifierBlockChanges(p));
        }
    }

    @Inject(method={"onUnloadChunk"}, at={@At(value="RETURN")})
    private void onChunkUnload(ClientboundForgetLevelChunkPacket packet, CallbackInfo ci) {
        if (!Configs.Generic.LOAD_ENTIRE_SCHEMATICS.getBooleanValue()) {
            DataManager.getSchematicPlacementManager().onClientChunkUnload(packet.m_132149_(), packet.m_132152_());
        }
    }

    @Inject(method={"onGameMessage"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/InGameHud;addChatMessage(Lnet/minecraft/network/MessageType;Lnet/minecraft/text/Text;Ljava/util/UUID;)V")})
    private void onGameMessage(ClientboundChatPacket packet, CallbackInfo ci) {
        if (DataManager.onChatMessage(packet.m_131836_())) {
            ci.cancel();
        }
    }
}

