/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.resourcepacks;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.maxhenkel.voicechat.Voicechat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;

public class VoiceChatResourcePack
extends AbstractPackResources {
    protected String path;
    protected Component name;

    public VoiceChatResourcePack(String path, Component name) {
        super(null);
        this.path = path;
        this.name = name;
    }

    @Nullable
    public Pack toPack() {
        try {
            PackMetadataSection packMetadataSection = (PackMetadataSection)this.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
            if (packMetadataSection == null) {
                return null;
            }
            return new Pack(this.path, false, () -> this, this.name, packMetadataSection.m_10373_(), PackCompatibility.m_143885_((PackMetadataSection)packMetadataSection, (PackType)PackType.CLIENT_RESOURCES), Pack.Position.TOP, false, PackSource.f_10528_);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String m_8017_() {
        return this.path;
    }

    private String getPath() {
        return "/packs/" + this.path + "/";
    }

    @Nullable
    private InputStream get(String name) {
        return Voicechat.class.getResourceAsStream(this.getPath() + name);
    }

    protected InputStream m_5541_(String name) throws IOException {
        InputStream resourceAsStream = this.get(name);
        if (resourceAsStream == null) {
            throw new FileNotFoundException("Resource " + name + " does not exist");
        }
        return resourceAsStream;
    }

    protected boolean m_6105_(String name) {
        try {
            return this.get(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Collection<ResourceLocation> m_7466_(PackType type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        ArrayList list = Lists.newArrayList();
        try {
            URL url = Voicechat.class.getResource(this.getPath());
            Path namespacePath = Paths.get(url.toURI()).resolve(type.m_10305_()).resolve(namespace);
            Path resPath = namespacePath.resolve(prefix);
            if (!Files.exists(resPath, new LinkOption[0])) {
                return list;
            }
            try (Stream<Path> files = Files.walk(resPath, new FileVisitOption[0]);){
                files.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    ResourceLocation resourceLocation = new ResourceLocation(namespace, VoiceChatResourcePack.convertPath(path).substring(VoiceChatResourcePack.convertPath(namespacePath).length() + 1));
                    list.add(resourceLocation);
                });
            }
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to list builtin pack resources", e);
        }
        return list.stream().filter(resourceLocation -> pathFilter.test(resourceLocation.m_135815_())).toList();
    }

    private static String convertPath(Path path) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < path.getNameCount(); ++i) {
            stringBuilder.append(path.getName(i));
            if (i >= path.getNameCount() - 1) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public Set<String> m_5698_(PackType packType) {
        if (packType == PackType.CLIENT_RESOURCES) {
            return ImmutableSet.of((Object)"voicechat");
        }
        return ImmutableSet.of();
    }

    public void close() {
    }
}

