/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import com.mojang.blaze3d.platform.InputConstants;
import de.maxhenkel.voicechat.events.ClientVoiceChatConnectedEvent;
import de.maxhenkel.voicechat.events.ClientVoiceChatDisconnectedEvent;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.Connection;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeClientCompatibilityManager
extends ClientCompatibilityManager {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final List<ClientCompatibilityManager.RenderNameplateEvent> renderNameplateEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.RenderNameplateEvent>();
    private final List<ClientCompatibilityManager.RenderHUDEvent> renderHUDEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.RenderHUDEvent>();
    private final List<ClientCompatibilityManager.KeyboardEvent> keyboardEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.KeyboardEvent>();
    private final List<ClientCompatibilityManager.MouseEvent> mouseEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.MouseEvent>();
    private final List<Runnable> clientTickEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> inputEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> disconnectEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> joinWorldEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<ClientVoicechatConnection>> voicechatConnectEvents = new CopyOnWriteArrayList<Consumer<ClientVoicechatConnection>>();
    private final List<Runnable> voicechatDisconnectEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<Integer>> publishServerEvents = new CopyOnWriteArrayList<Consumer<Integer>>();
    private boolean wasPublished;

    @SubscribeEvent
    public void onRenderName(RenderNameplateEvent event) {
        if (this.minecraft.f_91074_ == null || event.getEntity().m_20177_((Player)this.minecraft.f_91074_)) {
            return;
        }
        this.renderNameplateEvents.forEach(renderNameplateEvent -> renderNameplateEvent.render(event.getEntity(), event.getContent(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight()));
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.PostLayer event) {
        if (event.getOverlay() != ForgeIngameGui.HOTBAR_ELEMENT) {
            return;
        }
        this.renderHUDEvents.forEach(renderHUDEvent -> renderHUDEvent.render(event.getMatrixStack(), event.getPartialTicks()));
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        this.keyboardEvents.forEach(keyboardEvent -> keyboardEvent.onKeyboardEvent(this.minecraft.m_91268_().m_85439_(), event.getKey(), event.getScanCode()));
    }

    @SubscribeEvent
    public void onMouse(InputEvent.RawMouseEvent event) {
        this.mouseEvents.forEach(mouseEvent -> mouseEvent.onMouseEvent(this.minecraft.m_91268_().m_85439_(), event.getButton(), event.getAction(), event.getModifiers()));
    }

    @SubscribeEvent
    public void onKeyInput(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.clientTickEvents.forEach(Runnable::run);
    }

    @SubscribeEvent
    public void onInput(TickEvent.ClientTickEvent event) {
        this.inputEvents.forEach(Runnable::run);
    }

    @SubscribeEvent
    public void onDisconnect(WorldEvent.Unload event) {
        if (this.minecraft.f_91072_ == null) {
            this.disconnectEvents.forEach(Runnable::run);
        }
    }

    @SubscribeEvent
    public void onJoinServer(ClientPlayerNetworkEvent.LoggedInEvent event) {
        if (event.getPlayer() != this.minecraft.f_91074_) {
            return;
        }
        this.joinWorldEvents.forEach(Runnable::run);
    }

    @SubscribeEvent
    public void onServer(TickEvent.ServerTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        if (server == null) {
            return;
        }
        boolean published = server.m_6992_();
        if (published && !this.wasPublished) {
            this.publishServerEvents.forEach(portConsumer -> portConsumer.accept(server.m_7010_()));
        }
        this.wasPublished = published;
    }

    @Override
    public void onRenderNamePlate(ClientCompatibilityManager.RenderNameplateEvent onRenderNamePlate) {
        this.renderNameplateEvents.add(onRenderNamePlate);
    }

    @Override
    public void onRenderHUD(ClientCompatibilityManager.RenderHUDEvent onRenderHUD) {
        this.renderHUDEvents.add(onRenderHUD);
    }

    @Override
    public void onKeyboardEvent(ClientCompatibilityManager.KeyboardEvent onKeyboardEvent) {
        this.keyboardEvents.add(onKeyboardEvent);
    }

    @Override
    public void onMouseEvent(ClientCompatibilityManager.MouseEvent onMouseEvent) {
        this.mouseEvents.add(onMouseEvent);
    }

    @Override
    public void onClientTick(Runnable onClientTick) {
        this.clientTickEvents.add(onClientTick);
    }

    @Override
    public InputConstants.Key getBoundKeyOf(KeyMapping keyBinding) {
        return keyBinding.getKey();
    }

    @Override
    public void onHandleKeyBinds(Runnable onHandleKeyBinds) {
        this.inputEvents.add(onHandleKeyBinds);
    }

    @Override
    public KeyMapping registerKeyBinding(KeyMapping keyBinding) {
        ClientRegistry.registerKeyBinding((KeyMapping)keyBinding);
        return keyBinding;
    }

    @Override
    public void emitVoiceChatConnectedEvent(ClientVoicechatConnection client) {
        this.voicechatConnectEvents.forEach(consumer -> consumer.accept(client));
        MinecraftForge.EVENT_BUS.post((Event)new ClientVoiceChatConnectedEvent(client));
    }

    @Override
    public void emitVoiceChatDisconnectedEvent() {
        this.voicechatDisconnectEvents.forEach(Runnable::run);
        MinecraftForge.EVENT_BUS.post((Event)new ClientVoiceChatDisconnectedEvent());
    }

    @Override
    public void onVoiceChatConnected(Consumer<ClientVoicechatConnection> onVoiceChatConnected) {
        this.voicechatConnectEvents.add(onVoiceChatConnected);
    }

    @Override
    public void onVoiceChatDisconnected(Runnable onVoiceChatDisconnected) {
        this.voicechatDisconnectEvents.add(onVoiceChatDisconnected);
    }

    @Override
    public void onDisconnect(Runnable onDisconnect) {
        this.disconnectEvents.add(onDisconnect);
    }

    @Override
    public void onJoinWorld(Runnable onJoinWorld) {
        this.joinWorldEvents.add(onJoinWorld);
    }

    @Override
    public void onPublishServer(Consumer<Integer> onPublishServer) {
        this.publishServerEvents.add(onPublishServer);
    }

    @Override
    public SocketAddress getSocketAddress(Connection connection) {
        return connection.channel().remoteAddress();
    }

    @Override
    public void addResourcePackSource(PackRepository packRepository, RepositorySource repositorySource) {
        packRepository.addPackFinder(repositorySource);
    }
}

