/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.onboarding;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;

public abstract class OnboardingScreenBase
extends Screen {
    public static final Component NEXT = new TranslatableComponent("message.voicechat.onboarding.next");
    public static final Component BACK = new TranslatableComponent("message.voicechat.onboarding.back");
    public static final Component CANCEL = new TranslatableComponent("message.voicechat.onboarding.cancel");
    protected static final int TEXT_COLOR = -1;
    protected static final int PADDING = 8;
    protected static final int SMALL_PADDING = 2;
    protected static final int BUTTON_HEIGHT = 20;
    protected int contentWidth;
    protected int guiLeft;
    protected int guiTop;
    protected int contentHeight;
    @Nullable
    protected Screen previous;

    public OnboardingScreenBase(Component title, @Nullable Screen previous) {
        super(title);
        this.previous = previous;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.contentWidth = this.f_96543_ / 2;
        this.guiLeft = (this.f_96543_ - this.contentWidth) / 2;
        this.guiTop = 20;
        this.contentHeight = this.f_96544_ - this.guiTop * 2;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    @Nullable
    public Screen getNextScreen() {
        return null;
    }

    protected void addPositiveButton(Component text, Button.OnPress onPress) {
        Button nextButton = new Button(this.guiLeft + this.contentWidth / 2 + 4, this.guiTop + this.contentHeight - 20, this.contentWidth / 2 - 4, 20, text, onPress);
        this.m_142416_((GuiEventListener)nextButton);
    }

    protected void addNextButton() {
        this.addPositiveButton(NEXT, button -> this.f_96541_.m_91152_(this.getNextScreen()));
    }

    protected void addBackOrCancelButton(boolean big) {
        Component text = CANCEL;
        if (this.previous instanceof OnboardingScreenBase) {
            text = BACK;
        }
        Button cancel = new Button(this.guiLeft, this.guiTop + this.contentHeight - 20, big ? this.contentWidth : this.contentWidth / 2 - 4, 20, text, button -> this.f_96541_.m_91152_(this.previous));
        this.m_142416_((GuiEventListener)cancel);
    }

    protected void addBackOrCancelButton() {
        this.addBackOrCancelButton(false);
    }

    protected void renderTitle(PoseStack poseStack, Component titleComponent) {
        int titleWidth = this.f_96547_.m_92852_((FormattedText)titleComponent);
        this.f_96547_.m_92744_(poseStack, titleComponent.m_7532_(), (float)(this.f_96543_ / 2 - titleWidth / 2), (float)this.guiTop, -1);
    }

    protected void renderMultilineText(PoseStack poseStack, Component textComponent) {
        List text = this.f_96547_.m_92923_((FormattedText)textComponent, this.contentWidth);
        for (int i = 0; i < text.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)text.get(i);
            float f = this.f_96543_ / 2 - this.f_96547_.m_92724_(line) / 2;
            Objects.requireNonNull(this.f_96547_);
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92744_(poseStack, line, f, (float)(this.guiTop + 9 + 20 + i * (9 + 1)), -1);
        }
    }
}

