/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.config.ClientConfig;
import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.configbuilder.entry.ConfigEntry;
import de.maxhenkel.voicechat.configbuilder.entry.EnumConfigEntry;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ConfigMigrator {
    private static final String MOVED_CONFIG_KEY = "moved";
    private static final LevelResource SERVERCONFIG = new LevelResource("serverconfig");

    public static void migrateClientConfig() {
        ConfigMigrator.migrateConfig(ClientConfig.class, VoicechatClient.CLIENT_CONFIG, Voicechat.getConfigFolder().resolve("voicechat-client.toml"), true, "config/voicechat/voicechat-client.properties");
    }

    @SubscribeEvent
    public void onLoadLevel(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        ConfigMigrator.migrateConfig(ServerConfig.class, Voicechat.SERVER_CONFIG, serverLevel.m_142572_().m_129843_(SERVERCONFIG).resolve("voicechat-server.toml"), serverLevel.m_142572_().m_6982_(), "config/voicechat/voicechat-server.properties", "voice_chat");
    }

    public static <T> void migrateConfig(Class<T> configClass, T modConfig, Path forgeConfig, boolean copyValues, String newPath) {
        ConfigMigrator.migrateConfig(configClass, modConfig, forgeConfig, copyValues, newPath, null);
    }

    public static <T> void migrateConfig(Class<T> configClass, T modConfig, Path forgeConfig, boolean copyValues, String newPath, @Nullable String configKey) {
        try (CommentedFileConfig commentedConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)forgeConfig).build();){
            CommentedFileConfig config;
            Boolean migrated;
            if (Files.isRegularFile(forgeConfig, new LinkOption[0])) {
                commentedConfig.load();
            }
            if ((migrated = (Boolean)commentedConfig.get(MOVED_CONFIG_KEY)) != null && migrated.booleanValue()) {
                return;
            }
            Object object = config = configKey == null ? commentedConfig : (CommentedConfig)commentedConfig.get(configKey);
            if (config != null && copyValues) {
                ConfigMigrator.migrateConfigValues(configClass, modConfig, (CommentedConfig)config);
            }
            commentedConfig.clear();
            commentedConfig.set(MOVED_CONFIG_KEY, (Object)true);
            commentedConfig.setComment(MOVED_CONFIG_KEY, String.format(" This config has been moved to %s", newPath));
            commentedConfig.save();
            Voicechat.LOGGER.info("Successfully migrated config {}", forgeConfig.getFileName());
        }
    }

    public static <T> void migrateConfigValues(Class<T> configClass, T config, CommentedConfig forgeConfig) {
        Field[] declaredFields = configClass.getDeclaredFields();
        ConfigEntry randomEntry = null;
        for (Field field : declaredFields) {
            try {
                field.setAccessible(true);
                Object configEntry = field.get(config);
                if (!(configEntry instanceof ConfigEntry)) continue;
                ConfigEntry entry = (ConfigEntry)configEntry;
                if (randomEntry == null) {
                    randomEntry = entry;
                }
                Object forgeValue = forgeConfig.get(entry.getKey());
                ConfigMigrator.copyEntry(forgeValue, entry);
            }
            catch (IllegalAccessException e) {
                Voicechat.LOGGER.error("Failed to migrate config entry {}", field.getName(), e);
            }
        }
        if (randomEntry != null) {
            randomEntry.save();
        }
    }

    private static void copyEntry(Object forgeValue, ConfigEntry configEntry) {
        try {
            if (forgeValue == null) {
                return;
            }
            if (configEntry instanceof EnumConfigEntry) {
                EnumConfigEntry enumConfigEntry = (EnumConfigEntry)configEntry;
                forgeValue = Enum.valueOf(((Enum)enumConfigEntry.get()).getClass(), forgeValue.toString());
            }
            if (configEntry.getDefault().equals(forgeValue)) {
                return;
            }
            configEntry.set(forgeValue);
            Voicechat.LOGGER.debug("Migrated config entry '{}' with value '{}'", configEntry.getKey(), forgeValue);
        }
        catch (Throwable e) {
            Voicechat.LOGGER.error("Failed to migrate config entry {}", configEntry.getKey(), e);
        }
    }
}

