/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IDrawableComponent;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.component.DrawableComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class Tooltip
extends ObjectArrayList<Component>
implements ITooltip,
ITaggableList<ResourceLocation, Component> {
    private final Object2IntMap<ResourceLocation> tags = new Object2IntOpenHashMap();

    public void setLine(ResourceLocation tag, Line line) {
        if (this.tags.containsKey((Object)tag)) {
            this.set(this.tags.getInt((Object)tag), line);
        } else {
            this.tags.put((Object)tag, this.size);
            this.add(line);
        }
    }

    @Override
    public int getLineCount() {
        return this.size;
    }

    @Override
    public ITooltipLine getLine(int index) {
        Component component = (Component)this.get(index);
        if (component instanceof ITooltipLine) {
            ITooltipLine line = (ITooltipLine)component;
            return line;
        }
        Line line = new Line(null).with(component);
        this.set(index, line);
        return line;
    }

    @Override
    public ITooltipLine addLine() {
        Line line = new Line(null);
        this.add(line);
        return line;
    }

    @Override
    public ITooltipLine setLine(ResourceLocation tag) {
        Line line = new Line(tag);
        this.setLine(tag, line);
        return line;
    }

    @Override
    @Nullable
    public ITooltipLine getLine(ResourceLocation tag) {
        return this.tags.containsKey((Object)tag) ? this.getLine(this.tags.getInt((Object)tag)) : null;
    }

    @Override
    public IDrawableComponent addDrawable() {
        DrawableComponent component = new DrawableComponent();
        this.addLine().with(component);
        return component;
    }

    @Override
    public void setTag(ResourceLocation tag, Component value) {
        this.setLine(tag, value);
    }

    @Override
    public Component removeTag(ResourceLocation tag) {
        return this.tags.containsKey((Object)tag) ? (Component)this.remove(this.tags.removeInt((Object)tag)) : null;
    }

    @Override
    public Component getTag(ResourceLocation tag) {
        return this.tags.containsKey((Object)tag) ? (Component)this.get(this.tags.getInt((Object)tag)) : null;
    }

    @Override
    public Map<ResourceLocation, Component> getTags() {
        return this.tags.object2IntEntrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Component)this.get(e.getIntValue())));
    }

    @Override
    public void absorb(ITaggableList<ResourceLocation, Component> other) {
    }

    @Override
    public void clear() {
        super.clear();
        this.tags.clear();
    }
}

