/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class XPUtil {
    public static int takeXP(Player player, int xp) {
        int total = XPUtil.getXPTotal(player);
        int taken = Math.min(xp, total);
        XPUtil.setPlayersExpTo(player, total -= taken);
        return taken;
    }

    public static void giveXP(Player player, int xp) {
        XPUtil.setPlayersExpTo(player, XPUtil.getXPTotal(player) + xp);
    }

    public static void setPlayersExpTo(Player player, int total) {
        player.f_36078_ = Math.max(XPUtil.getLevelFromXPValue(total), 0);
        player.f_36080_ = Math.max(XPUtil.getCurrentFromXPValue(total), 0.0f);
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundSetExperiencePacket(player.f_36080_, player.f_36079_, player.f_36078_));
        }
    }

    public static int getXPTotal(int xpLevel, float current) {
        return (int)((float)XPUtil.getXPValueFromLevel(xpLevel) + (float)XPUtil.getXPValueToNextLevel(xpLevel) * current);
    }

    public static int getXPTotal(Player player) {
        return (int)((float)XPUtil.getXPValueFromLevel(player.f_36078_) + (float)XPUtil.getXPValueToNextLevel(player.f_36078_) * player.f_36080_);
    }

    public static int getLevelFromXPValue(int value) {
        int level = 0;
        level = value >= XPUtil.getXPValueFromLevel(30) ? (int)(0.07142857142857142 * (Math.sqrt(56.0 * (double)value - 32511.0) + 303.0)) : (value >= XPUtil.getXPValueFromLevel(15) ? (int)(0.16666666666666666 * (Math.sqrt(24.0 * (double)value - 5159.0) + 59.0)) : (int)((double)value / 17.0));
        return level;
    }

    public static float getCurrentFromXPValue(int value) {
        if (value == 0) {
            return 0.0f;
        }
        int level = XPUtil.getLevelFromXPValue(value);
        float needed = XPUtil.getXPValueFromLevel(level);
        float next = XPUtil.getXPValueToNextLevel(level);
        float difference = (float)value - needed;
        float current = difference / next;
        return current;
    }

    public static int getXPValueFromLevel(int xpLevel) {
        int val = 0;
        val = xpLevel >= 30 ? (int)(3.5 * Math.pow(xpLevel, 2.0) - 151.5 * (double)xpLevel + 2220.0) : (xpLevel >= 15 ? (int)(1.5 * Math.pow(xpLevel, 2.0) - 29.5 * (double)xpLevel + 360.0) : 17 * xpLevel);
        return val;
    }

    public static int getXPValueToNextLevel(int xpLevel) {
        int val = 0;
        val = xpLevel >= 30 ? 7 * xpLevel - 148 : (xpLevel >= 15 ? 3 * xpLevel - 28 : 17);
        return val;
    }
}

