/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own.inf;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.tiles.tooltip.own.IRenderableInfo;

public class StringTooltipInfo
implements IRenderableInfo {
    protected String text;
    public Font fontRenderer;
    public int color = -1;
    public boolean dropShadow = true;

    public StringTooltipInfo(String text) {
        this.text = text;
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public int getWidth() {
        return this.fontRenderer.m_92895_(this.getText());
    }

    @Override
    public int getHeight() {
        Objects.requireNonNull(this.fontRenderer);
        return 9;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack matrix, float x, float y, float partialTime) {
        if (this.dropShadow) {
            this.fontRenderer.m_92750_(matrix, this.getText(), x, y, this.color);
        } else {
            this.fontRenderer.m_92883_(matrix, this.getText(), x, y, this.color);
        }
    }

    public StringTooltipInfo appendColor(ChatFormatting tf) {
        this.text = tf.toString() + this.text;
        return this;
    }
}

