/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.zeith.hammerlib.tiles.tooltip.own.GuiTooltip;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltipProviderHC;

@OnlyIn(value=Dist.CLIENT)
public class EntityTooltipRenderEngine {
    public BlockPos lastPos;
    public UUID lastEntity;
    public GuiTooltip lastTooltip;

    public EntityTooltipRenderEngine() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderWorldLast(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            HitResult res = Minecraft.m_91087_().f_91077_;
            if (res != null) {
                EntityHitResult ehr;
                ITooltipProviderHC prov = null;
                if (res.m_6662_() == HitResult.Type.BLOCK && res instanceof BlockHitResult) {
                    boolean diffPos;
                    BlockHitResult bhr = (BlockHitResult)res;
                    ClientLevel wc = Minecraft.m_91087_().f_91073_;
                    BlockPos bp = bhr.m_82425_();
                    Block bl = wc.m_8055_(bp).m_60734_();
                    BlockEntity tl = wc.m_7702_(bp);
                    if (tl instanceof ITooltipProviderHC) {
                        prov = (ITooltipProviderHC)tl;
                    } else if (bl instanceof ITooltipProviderHC) {
                        prov = (ITooltipProviderHC)bl;
                    }
                    boolean bl2 = diffPos = !Objects.equals(bp, this.lastPos);
                    if (diffPos) {
                        this.lastPos = bp;
                        this.lastTooltip = null;
                    }
                    if (prov != null && (diffPos || prov.isTooltipDirty())) {
                        prov.setTooltipDirty(false);
                        this.lastTooltip = new GuiTooltip().withLocation((Level)wc, bp).withProvider(prov);
                    }
                } else if (res.m_6662_() == HitResult.Type.ENTITY && res instanceof EntityHitResult && (ehr = (EntityHitResult)res).m_82443_() instanceof ITooltipProviderHC) {
                    boolean diffEntity;
                    Entity ent = ehr.m_82443_();
                    prov = (ITooltipProviderHC)ent;
                    boolean bl = diffEntity = !Objects.equals(ent.m_142081_(), this.lastEntity);
                    if (diffEntity) {
                        this.lastEntity = ent.m_142081_();
                        this.lastTooltip = null;
                    }
                    if (diffEntity || prov.isTooltipDirty()) {
                        prov.setTooltipDirty(false);
                        this.lastTooltip = new GuiTooltip().withEntity(ent).withProvider(prov);
                    }
                } else {
                    this.lastPos = null;
                    this.lastTooltip = null;
                }
            } else {
                this.lastPos = null;
                this.lastTooltip = null;
            }
            if (this.lastTooltip != null) {
                int sw = e.getWindow().m_85445_();
                int sh = e.getWindow().m_85446_();
                float cx = (float)sw / 2.0f + 12.0f;
                float cy = ((float)sh - (float)this.lastTooltip.getHeight()) / 2.0f + 2.0f;
                float pt = e.getPartialTicks();
                this.lastTooltip.render(e.getMatrixStack(), cx, cy, pt);
            }
        }
    }
}

