/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyString
implements IProperty<String> {
    final DirectStorage<String> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyString(DirectStorage<String> value) {
        this.value = value;
    }

    public PropertyString() {
        this(DirectStorage.allocate());
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public String set(String value) {
        String pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        String value = this.value.get();
        buf.writeBoolean(value != null);
        if (value != null) {
            buf.m_130070_(value);
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value.set(buf.readBoolean() ? buf.m_130277_() : null);
    }

    @Override
    public String get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

