/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyShort
implements IProperty<Short> {
    final DirectStorage<Short> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyShort(DirectStorage<Short> value) {
        this.value = value;
    }

    public PropertyShort() {
        this(DirectStorage.allocate((short)0));
    }

    @Override
    public Class<Short> getType() {
        return Short.class;
    }

    @Override
    public Short set(Short value) {
        Short pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeShort((int)this.value.get().shortValue());
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.value.set(buf.readShort());
    }

    @Override
    public Short get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

