/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter.recipe;

import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.zeith.hammerlib.core.adapter.recipe.RecipeGroup;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;

public abstract class RecipeBuilder<R extends RecipeBuilder<R>> {
    protected final RegisterRecipesEvent event;
    protected ResourceLocation identifier;
    protected String group = "";
    protected ItemStack result = ItemStack.f_41583_;

    public RecipeBuilder(RegisterRecipesEvent event) {
        this.event = event;
    }

    public R id(ResourceLocation identifier) {
        this.identifier = identifier;
        return (R)this;
    }

    public R group(String group) {
        this.group = group;
        return (R)this;
    }

    public R group(RecipeGroup group) {
        this.group = group.toString();
        return (R)this;
    }

    public R result(ItemStack stack) {
        this.result = stack;
        return (R)this;
    }

    public R result(ItemLike provider) {
        this.result = new ItemStack(provider);
        return (R)this;
    }

    public R result(ItemLike provider, int count) {
        this.result = new ItemStack(provider, count);
        return (R)this;
    }

    protected ResourceLocation getIdentifier() {
        if (this.identifier != null) {
            return this.identifier;
        }
        return this.event.nextId(this.result.m_41720_());
    }

    protected void validate() {
        if (this.result.m_41619_()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a defined result!");
        }
    }

    public abstract void register();

    public void registerIf(BooleanSupplier condition) {
        if (condition.getAsBoolean()) {
            this.register();
        }
    }

    public void registerIf(Predicate<ResourceLocation> condition) {
        if (condition.test(this.identifier)) {
            this.register();
        }
    }
}

