/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import org.zeith.hammerlib.core.adapter.TagAdapter;

public class BlockHarvestAdapter {
    public static void bindToolType(MineableType tool, Block ... blocks) {
        TagAdapter.bindStaticTag(tool.blockTag(), blocks);
    }

    public static void bindToolTier(Tier tier, Block ... blocks) {
        TagAdapter.bindStaticTag((TagKey<Block>)tier.getTag(), blocks);
    }

    public static void bindTool(MineableType tool, Tier tier, Block ... blocks) {
        BlockHarvestAdapter.bindToolType(tool, blocks);
        BlockHarvestAdapter.bindToolTier(tier, blocks);
    }

    public record MineableType(@Nonnull TagKey<Block> blockTag) {
        public static final MineableType AXE = new MineableType((TagKey<Block>)BlockTags.f_144280_);
        public static final MineableType HOE = new MineableType((TagKey<Block>)BlockTags.f_144281_);
        public static final MineableType PICKAXE = new MineableType((TagKey<Block>)BlockTags.f_144282_);
        public static final MineableType SHOVEL = new MineableType((TagKey<Block>)BlockTags.f_144283_);

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MineableType that = (MineableType)o;
            return this.blockTag.equals(that.blockTag);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.blockTag);
        }
    }
}

