/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.pipelines.shaders;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.Setup;
import org.zeith.hammerlib.client.pipelines.shaders.InitializeShadersEvent;
import org.zeith.hammerlib.client.pipelines.shaders.ShaderSource;
import org.zeith.hammerlib.client.pipelines.shaders.ShaderVar;
import org.zeith.hammerlib.client.utils.GLBuffer;
import org.zeith.hammerlib.client.utils.GLHelperHL;
import org.zeith.hammerlib.util.java.Once;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class VariableShaderProgram {
    private static final List<VariableShaderProgram> PROGRAMS = new ArrayList<VariableShaderProgram>();
    private static final Map<ResourceLocation, VariableShaderProgram> PROGRAM_REGISTRY = new HashMap<ResourceLocation, VariableShaderProgram>();
    private final Int2ObjectArrayMap<ShaderSource> sources = new Int2ObjectArrayMap();
    private final List<ShaderVar> variables = new ArrayList<ShaderVar>();
    private final Object2IntArrayMap<String> uniformCache = new Object2IntArrayMap();
    private final List<Consumer<VariableShaderProgram>> onBind = new ArrayList<Consumer<VariableShaderProgram>>();
    private final List<Consumer<VariableShaderProgram>> onCompilationFailed = new ArrayList<Consumer<VariableShaderProgram>>();
    private Integer program;
    private ResourceLocation id;
    private boolean doGLLog = true;
    private boolean hasCompiled;
    private boolean compilationFailed;
    private final List<Throwable> compilationErrors = new ArrayList<Throwable>();
    private static final Once initShaders = Once.run(() -> HammerLib.postEvent(new InitializeShadersEvent()));

    public VariableShaderProgram id(ResourceLocation id) {
        if (this.id == null) {
            if (PROGRAM_REGISTRY.containsKey(id)) {
                throw new RuntimeException("Duplicate shader pipeline id: " + id);
            }
        } else {
            throw new RuntimeException("ID already assigned to shader pipe: " + this.id + " (tried to override to " + id + ")");
        }
        this.id = id;
        PROGRAM_REGISTRY.put(id, this);
        return this;
    }

    public VariableShaderProgram doGLLog(boolean flag) {
        this.doGLLog = flag;
        return this;
    }

    public VariableShaderProgram subscribe4Events() {
        if (!PROGRAMS.contains(this)) {
            PROGRAMS.add(this);
        }
        return this;
    }

    public VariableShaderProgram addVariable(ShaderVar var) {
        var.setProgram(this);
        this.variables.add(var);
        return this;
    }

    public VariableShaderProgram onBind(Consumer<VariableShaderProgram> onBind) {
        this.onBind.add(onBind);
        return this;
    }

    public VariableShaderProgram linkGeometrySource(ShaderSource src) {
        return this.linkSource(36313, src);
    }

    public VariableShaderProgram linkVertexSource(ShaderSource src) {
        return this.linkSource(35633, src);
    }

    public VariableShaderProgram linkFragmentSource(ShaderSource src) {
        return this.linkSource(35632, src);
    }

    public VariableShaderProgram linkSource(int type, ShaderSource src) {
        this.sources.put(type, (Object)src);
        return this;
    }

    public VariableShaderProgram onCompilationFailed(Consumer<VariableShaderProgram> errorHandler) {
        this.onCompilationFailed.add(errorHandler);
        return this;
    }

    protected void createProgram() {
        this.hasCompiled = false;
        this.compilationFailed = false;
        this.compilationErrors.clear();
        try {
            if (this.program != null) {
                GL20.glDeleteProgram((int)this.program);
            }
            this.uniformCache.clear();
            this.program = GL20.glCreateProgram();
            IntArrayList shaders = new IntArrayList();
            IntIterator intIterator = this.sources.keySet().iterator();
            while (intIterator.hasNext()) {
                int key = (Integer)intIterator.next();
                int shader = GL20.glCreateShader((int)key);
                if (shader == 0) continue;
                GL20.glShaderSource((int)shader, (CharSequence)((ShaderSource)this.sources.get(key)).read(this.variables));
                GL20.glCompileShader((int)shader);
                if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
                    String gl = GL20.glGetProgramInfoLog((int)shader, (int)ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35716));
                    RuntimeException err2 = new RuntimeException("Failed to load shader(" + Integer.toHexString(key) + ") source " + this.sources.get(key) + ":\n" + gl);
                    this.compilationErrors.add(err2);
                    GL20.glDeleteShader((int)shader);
                    continue;
                }
                GL20.glAttachShader((int)this.program, (int)shader);
                shaders.add(shader);
            }
            GL20.glLinkProgram((int)this.program);
            String s = GL20.glGetProgramInfoLog((int)this.program, (int)ARBShaderObjects.glGetObjectParameteriARB((int)this.program, (int)35716));
            if (!s.isEmpty() && this.doGLLog) {
                System.out.println("GL LOG: " + s.trim());
            }
            IntListIterator intListIterator = shaders.iterator();
            while (intListIterator.hasNext()) {
                int i = (Integer)intListIterator.next();
                GL20.glDeleteShader((int)i);
            }
            this.hasCompiled = true;
            this.compilationFailed = false;
        }
        catch (Throwable err3) {
            this.compilationErrors.add(err3);
        }
        if (!this.compilationErrors.isEmpty()) {
            if (this.program != null) {
                GL20.glDeleteProgram((int)this.program);
            }
            this.program = null;
            this.hasCompiled = false;
            this.compilationFailed = true;
            this.compilationErrors.forEach(err -> HammerLib.LOG.error("Shader " + this.getId() + " error:", err));
            this.onCompilationFailed.forEach(c -> c.accept(this));
        }
    }

    public void update() {
        if (this.program == null && this.variables.stream().peek(ShaderVar::update).anyMatch(v -> v.hasChanged)) {
            this.createProgram();
            this.variables.forEach(v -> {
                v.hasChanged = false;
            });
        }
    }

    public void onReload() {
        this.createProgram();
    }

    public boolean hasCompiled() {
        return this.hasCompiled;
    }

    public boolean hasCompilationFailed() {
        return this.compilationFailed;
    }

    public List<Throwable> getCompilationErrors() {
        return this.compilationErrors;
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    public int getUniformLocation(String location) {
        if (this.program == null) {
            return 0;
        }
        if (!this.uniformCache.containsKey((Object)location)) {
            this.uniformCache.put((Object)location, GL20.glGetUniformLocation((int)this.program, (CharSequence)location));
        }
        return this.uniformCache.getInt((Object)location);
    }

    public void setUniform(String uniform, int value) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform1i((int)this.getUniformLocation(uniform), (int)value);
    }

    public void setUniform(String uniform, boolean value) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform1i((int)this.getUniformLocation(uniform), (int)(value ? 1 : 0));
    }

    public void setUniform(String uniform, float value) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform1f((int)this.getUniformLocation(uniform), (float)value);
    }

    public void setUniform(String uniform, int v1, int v2) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform2i((int)this.getUniformLocation(uniform), (int)v1, (int)v2);
    }

    public void setUniform(String uniform, int v1, int v2, int v3) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform3i((int)this.getUniformLocation(uniform), (int)v1, (int)v2, (int)v3);
    }

    public void setUniform(String uniform, float v1, float v2) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform2f((int)this.getUniformLocation(uniform), (float)v1, (float)v2);
    }

    public void setUniform(String uniform, float v1, float v2, float v3) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform3f((int)this.getUniformLocation(uniform), (float)v1, (float)v2, (float)v3);
    }

    public void setUniform(String uniform, float v1, float v2, float v3, float v4) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform4f((int)this.getUniformLocation(uniform), (float)v1, (float)v2, (float)v3, (float)v4);
    }

    public void setBuffer(String blockName, GLBuffer buffer) {
        if (!this.hasCompiled) {
            return;
        }
        buffer.bindToShader(this.program, 0, blockName);
    }

    public void bindShader() {
        if (this.compilationFailed) {
            return;
        }
        if (this.program == null) {
            this.createProgram();
        }
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUseProgram((int)this.program);
        if (!this.onBind.isEmpty()) {
            this.onBind.forEach(c -> c.accept(this));
        }
    }

    public void unbindShader() {
        GL20.glUseProgram((int)0);
    }

    @Setup(side={Dist.CLIENT})
    public static void reloadShaders() {
        initShaders.call();
        Minecraft.m_91087_().execute(() -> {
            HammerLib.LOG.info("Reloading " + PROGRAMS.size() + " variable shader programs.");
            PROGRAMS.forEach(VariableShaderProgram::onReload);
        });
    }

    @SubscribeEvent
    public static void tickShader(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            PROGRAMS.forEach(VariableShaderProgram::update);
        }
    }

    public static VariableShaderProgram byId(ResourceLocation id) {
        return PROGRAM_REGISTRY.get(id);
    }

    public boolean isActive() {
        return this.hasCompiled && this.program != null && this.program.equals(GLHelperHL.activeShaderProgram());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ShaderErrorToast
    implements Toast {
        private String title;
        private String subtitle;
        private long firstDrawTime;
        private boolean newDisplay;

        public ShaderErrorToast(TextComponent titleComponent, @Nullable TextComponent subtitleComponent) {
            this.title = titleComponent.m_6111_();
            this.subtitle = subtitleComponent == null ? null : subtitleComponent.m_6111_();
        }

        public Toast.Visibility m_7172_(PoseStack m, ToastComponent toastGui, long delta) {
            if (this.newDisplay) {
                this.firstDrawTime = delta;
                this.newDisplay = false;
            }
            toastGui.m_94929_().m_91097_().m_174784_(f_94893_);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            toastGui.m_93228_(m, 0, 0, 0, 64, 160, 32);
            if (this.subtitle == null) {
                toastGui.m_94929_().f_91062_.m_92883_(m, this.title, 18.0f, 12.0f, -256);
            } else {
                toastGui.m_94929_().f_91062_.m_92883_(m, this.title, 18.0f, 7.0f, -256);
                toastGui.m_94929_().f_91062_.m_92883_(m, this.subtitle, 18.0f, 18.0f, -1);
            }
            return delta - this.firstDrawTime < 5000L ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
        }

        public void setDisplayedText(TextComponent titleComponent, @Nullable TextComponent subtitleComponent) {
            this.title = titleComponent.m_6111_();
            this.subtitle = subtitleComponent == null ? null : subtitleComponent.m_6111_();
            this.newDisplay = true;
        }
    }

    public static enum ToastCompilationErrorHandler implements Consumer<VariableShaderProgram>
    {
        INSTANCE;


        @Override
        public void accept(VariableShaderProgram program) {
            if (program.hasCompilationFailed()) {
                int errors;
                ShaderErrorToast toast = new ShaderErrorToast(new TextComponent(errors + " Shader Error" + ((errors = program.getCompilationErrors().size()) > 1 ? "s" : "")), new TextComponent(program.getId() + " failed. :<"));
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)toast);
            }
        }
    }
}

